/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.commands;

import chanceCubes.CCubesCore;
import chanceCubes.client.ClientHelper;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.commands.InfoAction;
import chanceCubes.commands.RewardArgument;
import chanceCubes.commands.RewardInfoActionArgument;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerRewardInfo;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;

public class CCubesServerCommands {
    public CCubesServerCommands(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"chancecubes").then(Commands.func_197057_a((String)"reload").executes(this::executeReload))).then(Commands.func_197057_a((String)"version").executes(this::executeVersion))).then(Commands.func_197057_a((String)"handNBT").executes(this::executeHandNBT))).then(Commands.func_197057_a((String)"handID").executes(this::executeHandID))).then(Commands.func_197057_a((String)"disableReward").then(Commands.func_197056_a((String)"rewardName", (ArgumentType)new RewardArgument()).executes(ctx -> this.executeDisableReward((CommandContext<CommandSource>)ctx, RewardArgument.getReward((CommandContext<CommandSource>)ctx, "rewardName")))))).then(Commands.func_197057_a((String)"enableReward").then(Commands.func_197056_a((String)"rewardName", (ArgumentType)new RewardArgument()).executes(ctx -> this.executeEnableReward((CommandContext<CommandSource>)ctx, RewardArgument.getReward((CommandContext<CommandSource>)ctx, "rewardName")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"schematic").requires(cs -> cs.func_197034_c(2))).requires(cs -> cs.func_197023_e().field_72995_K)).then(Commands.func_197057_a((String)"create").executes(this::executeSchematicCreate))).then(Commands.func_197057_a((String)"cancel").executes(this::executeSchematicCancel)))).then(Commands.func_197057_a((String)"rewardsInfo").then(Commands.func_197056_a((String)"action", (ArgumentType)new RewardInfoActionArgument()).executes(ctx -> this.executeRewardInfo((CommandContext<CommandSource>)ctx, RewardInfoActionArgument.func_212592_a((CommandContext<CommandSource>)ctx, "action")))))).then(Commands.func_197057_a((String)"test").executes(this::executeTest))).then(Commands.func_197057_a((String)"testRewards").executes(this::executeTestRewards))).then(Commands.func_197057_a((String)"testCustomRewards").executes(this::executeTestCustomRewards))).then(Commands.func_197057_a((String)"spawnGiantCube").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> this.executeSpawnGiantCube((CommandContext<CommandSource>)ctx, BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos")))))).then(Commands.func_197057_a((String)"spawnReward").then(Commands.func_197056_a((String)"rewardName", (ArgumentType)new RewardArgument()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> this.executeSpawnReward((CommandContext<CommandSource>)ctx, RewardArgument.getReward((CommandContext<CommandSource>)ctx, "rewardName"), EntityArgument.func_197090_e((CommandContext)ctx, (String)"target")))))));
    }

    public ServerPlayerEntity getPlayer(CommandSource source) {
        try {
            return source.func_197035_h();
        }
        catch (CommandSyntaxException e) {
            CCubesCore.logger.log(Level.ERROR, "You should never see this. If you do you broke everything. Report to Turkey");
            return null;
        }
    }

    public int executeReload(CommandContext<CommandSource> ctx) {
        new Thread(() -> {
            GlobalCCRewardRegistry.DEFAULT.ClearRewards();
            GlobalCCRewardRegistry.GIANT.ClearRewards();
            ConfigLoader.reload();
            DefaultRewards.loadDefaultRewards();
            DefaultGiantRewards.loadDefaultRewards();
            CustomRewardsLoader.instance.loadCustomRewards();
            GlobalCCRewardRegistry.loadCustomUserRewards(ServerLifecycleHooks.getCurrentServer());
            NonreplaceableBlockOverride.loadOverrides();
            RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Rewards Reloaded");
        }).start();
        return 0;
    }

    public int executeVersion(CommandContext<CommandSource> ctx) {
        String ver = ((ModContainer)ModList.get().getModContainerById("chancecubes").get()).getModInfo().getVersion().toString();
        RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Chance Cubes Version " + ver);
        return 0;
    }

    public int executeHandNBT(CommandContext<CommandSource> ctx) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        CompoundNBT nbt = player.field_71071_by.func_70448_g().func_196082_o();
        RewardsUtil.sendMessageToPlayer((PlayerEntity)player, nbt.toString());
        return 0;
    }

    public int executeHandID(CommandContext<CommandSource> ctx) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b()) {
            ResourceLocation res = stack.func_77973_b().getRegistryName();
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, res.func_110624_b() + ":" + res.func_110623_a());
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "meta: " + stack.func_77952_i());
        }
        return 0;
    }

    public int executeDisableReward(CommandContext<CommandSource> ctx, String reward) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        if (GlobalCCRewardRegistry.DEFAULT.disableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, reward + " Has been disabled.");
        } else if (GlobalCCRewardRegistry.GIANT.disableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, reward + " Has been disabled.");
        } else {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, reward + " is either not currently enabled or is not a valid reward name.");
        }
        return 0;
    }

    public int executeEnableReward(CommandContext<CommandSource> ctx, String reward) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        if (GlobalCCRewardRegistry.DEFAULT.enableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, reward + " Has been enabled.");
        } else if (GlobalCCRewardRegistry.GIANT.enableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, reward + " Has been enabled.");
        } else {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)player, reward + " is either not currently disabled or is not a valid reward name.");
        }
        return 0;
    }

    public int executeSchematicCreate(CommandContext<CommandSource> ctx) {
        if (RenderEvent.isCreatingSchematic()) {
            if (SchematicUtil.selectionPoints[0] != null && SchematicUtil.selectionPoints[1] != null) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.openSchematicCreatorGUI((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource())));
            } else {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Please set both points before moving on!");
            }
        } else {
            RenderEvent.setCreatingSchematic(true);
        }
        return 0;
    }

    public int executeSchematicCancel(CommandContext<CommandSource> ctx) {
        RenderEvent.setCreatingSchematic(false);
        SchematicUtil.selectionPoints[0] = null;
        SchematicUtil.selectionPoints[1] = null;
        return 0;
    }

    public int executeRewardInfo(CommandContext<CommandSource> ctx, InfoAction action) {
        ServerPlayerEntity player = this.getPlayer((CommandSource)ctx.getSource());
        List<PlayerRewardInfo> defaultrewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(player.func_110124_au().toString()).getPlayersRewards();
        List<PlayerRewardInfo> giantrewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(player.func_110124_au().toString()).getPlayersRewards();
        int defaultEnabled = defaultrewards.size();
        int giantEnabled = giantrewards.size();
        ArrayList<String> playerRewards = new ArrayList<String>();
        switch (action) {
            case DEFAULT: {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "===DEFAULT REWARDS===");
                for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, playerRewardInfo.reward.getName());
                }
                break;
            }
            case GIANT: {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "===GIANT REWARDS===");
                for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, playerRewardInfo.reward.getName());
                }
                break;
            }
            case DEFAULT_ALL: {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "===DEFAULT REWARDS===");
                for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, string);
                }
                break;
            }
            case GIANT_ALL: {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "===GIANT REWARDS===");
                for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, string);
                }
                break;
            }
            case DEFAULT_DISABLED: {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "===DEFAULT REWARDS DISABLED===");
                for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                    playerRewards.add(playerRewardInfo.reward.getName());
                }
                for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                    if (playerRewards.contains(string)) continue;
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, string);
                }
                break;
            }
            case GIANT_DISABLED: {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "===GIANT REWARDS DISABLED===");
                for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                    playerRewards.add(playerRewardInfo.reward.getName());
                }
                for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                    if (playerRewards.contains(string)) continue;
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, string);
                }
                break;
            }
        }
        RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "There are currently " + GlobalCCRewardRegistry.DEFAULT.getNumberOfLoadedRewards() + " regular rewards loaded and you have " + defaultEnabled + " rewards enabled");
        RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "There are currently " + GlobalCCRewardRegistry.GIANT.getNumberOfLoadedRewards() + " giant rewards loaded and you have " + giantEnabled + " rewards enabled");
        return 0;
    }

    public int executeTestRewards(CommandContext<CommandSource> ctx) {
        CCubesSettings.testRewards = !CCubesSettings.testRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testRewards) {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Reward testing is now enabled for all rewards!");
        } else {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Reward testing is now disabled and normal randomness is back.");
        }
        return 0;
    }

    public int executeTestCustomRewards(CommandContext<CommandSource> ctx) {
        CCubesSettings.testCustomRewards = !CCubesSettings.testCustomRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testCustomRewards) {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Reward testing is now enabled for custom rewards!");
        } else {
            RewardsUtil.sendMessageToPlayer((PlayerEntity)this.getPlayer((CommandSource)ctx.getSource()), "Reward testing is now disabled and normal randomness is back.");
        }
        return 0;
    }

    public int executeTest(CommandContext<CommandSource> ctx) {
        return 0;
    }

    public int executeSpawnGiantCube(CommandContext<CommandSource> ctx, BlockPos pos) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        if (RewardsUtil.isBlockUnbreakable((World)world, pos.func_177982_a(0, 0, 0)) && CCubesSettings.nonReplaceableBlocks.contains(world.func_180495_p(pos.func_177982_a(0, 0, 0)))) {
            return 0;
        }
        GiantCubeUtil.setupStructure(pos.func_177982_a(-1, -1, -1), (World)world, true);
        world.func_184133_a(null, pos, CCubesSounds.GIANT_CUBE_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return 0;
    }

    public int executeSpawnReward(CommandContext<CommandSource> ctx, String rewardName, Collection<ServerPlayerEntity> targets) {
        IChanceCubeReward reward = GlobalCCRewardRegistry.DEFAULT.getRewardByName(rewardName);
        if (reward == null) {
            reward = GlobalCCRewardRegistry.GIANT.getRewardByName(rewardName);
        }
        if (reward == null) {
            CCubesCore.logger.log(Level.ERROR, rewardName + " is not a valid reward in the spawnReward command!");
            return 0;
        }
        CCubesCore.logger.log(Level.INFO, "spawnReward command is spawning " + rewardName);
        for (ServerPlayerEntity target : targets) {
            reward.trigger(((CommandSource)ctx.getSource()).func_197023_e(), target.func_233580_cy_(), (PlayerEntity)target, new JsonObject());
        }
        return 0;
    }
}

