/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.GuiButtonFixed;
import team.creative.creativecore.common.gui.controls.GuiScrollBox;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;

public class GuiListBoxBase<T extends GuiControl>
extends GuiScrollBox {
    protected List<T> content;
    protected List<GuiButtonRemove> removeButtons;
    public final boolean modifiable;
    public int space = 2;

    public GuiListBoxBase(String name, int x, int y, int width, int height, boolean modifiable, List<T> entries) {
        super(name, x, y, width, height);
        this.content = entries;
        this.modifiable = modifiable;
        if (modifiable) {
            this.removeButtons = new ArrayList<GuiButtonRemove>();
        }
        for (int i = 0; i < entries.size(); ++i) {
            this.add((GuiControl)entries.get(i));
            if (!modifiable) continue;
            GuiButtonRemove button = new GuiButtonRemove(i);
            this.add(button);
            this.removeButtons.add(button);
        }
        this.reloadPositions();
    }

    public void reloadPositions() {
        int y = this.space / 2;
        for (int i = 0; i < this.content.size(); ++i) {
            GuiControl control = (GuiControl)this.content.get(i);
            if (this.modifiable) {
                GuiButtonRemove button = this.removeButtons.get(i);
                button.index = i;
                button.setY(y + 3);
            }
            control.setY(y);
            y += control.getHeight() + this.space;
        }
    }

    public void removeItem(int index) {
        this.remove((GuiControl)this.content.get(index));
        this.content.remove(index);
        if (this.modifiable) {
            this.remove(this.removeButtons.get(index));
            this.removeButtons.remove(index);
            for (int i = 0; i < this.removeButtons.size(); ++i) {
                this.removeButtons.get((int)i).index = i;
            }
        }
        this.reloadPositions();
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public void clearItems() {
        for (int i = 0; i < this.content.size(); ++i) {
            this.remove((GuiControl)this.content.get(i));
            if (!this.modifiable) continue;
            this.remove(this.removeButtons.get(i));
        }
        this.content.clear();
        if (this.modifiable) {
            this.removeButtons.clear();
        }
    }

    public void addAllItems(List<T> entries) {
        for (GuiControl entry : entries) {
            this.content.add(entry);
            this.add(entry);
            if (!this.modifiable) continue;
            GuiButtonRemove button = new GuiButtonRemove(this.content.size() - 1);
            this.add(button);
            this.removeButtons.add(button);
        }
        this.reloadPositions();
    }

    public void addItem(T entry) {
        this.content.add(entry);
        this.add((GuiControl)entry);
        if (this.modifiable) {
            GuiButtonRemove button = new GuiButtonRemove(this.content.size() - 1);
            this.add(button);
            this.removeButtons.add(button);
        }
        if (this.content.size() == 1) {
            this.reloadPositions();
        } else {
            GuiControl before = (GuiControl)this.content.get(this.content.size() - 2);
            ((GuiControl)entry).setY(before.getY() + before.getHeight() + this.space);
            if (this.modifiable) {
                this.removeButtons.get(this.removeButtons.size() - 1).setY(before.getY() + before.getHeight() + this.space + 3);
            }
        }
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public int size() {
        return this.content.size();
    }

    public T get(int index) {
        return (T)((GuiControl)this.content.get(index));
    }

    public class GuiButtonRemove
    extends GuiButtonFixed {
        public int index;

        public GuiButtonRemove(int index) {
            super("x", GuiListBoxBase.this.getWidth() - 25, 0, 12, 12, null);
            this.setTitle((ITextComponent)new StringTextComponent("x"));
            this.pressed = x -> GuiListBoxBase.this.removeItem(this.index);
            this.index = index;
        }
    }
}

