/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LC;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import net.minecraft.util.math.vector.Vector3i;

public class LightCoordAttribute
extends VertexAttribute<LC[]> {
    public static final AttributeKey<LC[]> attributeKey = new AttributeKey<LC[]>("light_coord", LC[]::new);
    private final Vector3 vec = new Vector3();
    private final Vector3 pos = new Vector3();
    private LC[] lcRef;

    public LightCoordAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        this.lcRef = ccrs.model.getAttributes(attributeKey);
        if (ccrs.model.hasAttribute(attributeKey)) {
            return this.lcRef != null;
        }
        this.pos.set((Vector3i)ccrs.lightMatrix.pos);
        ccrs.pipeline.addDependency(ccrs.sideAttrib);
        ccrs.pipeline.addRequirement(Transformation.operationIndex);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        if (this.lcRef != null) {
            ccrs.lc.set(this.lcRef[ccrs.vertexIndex]);
        } else {
            ccrs.lc.compute(this.vec.set(ccrs.vert.vec).subtract(this.pos), ccrs.side);
        }
    }
}

