/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.util.ItemUtils;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtils {
    @CapabilityInject(value=IItemHandler.class)
    public static final Capability<IItemHandler> ITEM_HANDLER = null;

    @Nonnull
    public static ItemStack decrStackSize(IInventory inv, int slot, int size) {
        ItemStack item = inv.func_70301_a(slot);
        if (!item.func_190926_b()) {
            if (item.func_190916_E() <= size) {
                inv.func_70299_a(slot, ItemStack.field_190927_a);
                inv.func_70296_d();
                return item;
            }
            ItemStack itemstack1 = item.func_77979_a(size);
            if (item.func_190916_E() == 0) {
                inv.func_70299_a(slot, ItemStack.field_190927_a);
            } else {
                inv.func_70299_a(slot, item);
            }
            inv.func_70296_d();
            return itemstack1;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack removeStackFromSlot(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        inv.func_70299_a(slot, ItemStack.field_190927_a);
        return stack;
    }

    public static int incrStackSize(@Nonnull ItemStack base, @Nonnull ItemStack addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.func_190916_E());
        }
        return 0;
    }

    public static int incrStackSize(@Nonnull ItemStack base, int addition) {
        int totalSize = base.func_190916_E() + addition;
        if (totalSize <= base.func_77976_d()) {
            return addition;
        }
        if (base.func_190916_E() < base.func_77976_d()) {
            return base.func_77976_d() - base.func_190916_E();
        }
        return 0;
    }

    public static ListNBT writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static ListNBT writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < items.length; ++i) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", items[i].func_190916_E());
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)items[i].func_190916_E());
            }
            tagList.add((Object)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, ListNBT tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_199557_a((CompoundNBT)tag);
            INBT quant = tag.func_74781_a("Quantity");
            if (!(quant instanceof NumberNBT)) continue;
            items[b].func_190920_e(((NumberNBT)quant).func_150287_d());
        }
    }

    public static int getInsertibleQuantity(InventoryRange inv, @Nonnull ItemStack stack) {
        int quantity = 0;
        stack = ItemUtils.copyStack(stack, Integer.MAX_VALUE);
        for (int slot : inv.slots) {
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
        }
        return quantity;
    }

    public static int getInsertibleQuantity(IInventory inv, @Nonnull ItemStack stack) {
        return InventoryUtils.getInsertibleQuantity(new InventoryRange(inv), stack);
    }

    public static int fitStackInSlot(InventoryRange inv, int slot, ItemStack stack) {
        ItemStack base = inv.inv.func_70301_a(slot);
        if (!InventoryUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = !base.func_190926_b() ? InventoryUtils.incrStackSize(base, inv.inv.func_70297_j_() - base.func_190916_E()) : inv.inv.func_70297_j_();
        return Math.min(fit, stack.func_190916_E());
    }

    public static int fitStackInSlot(IInventory inv, int slot, @Nonnull ItemStack stack) {
        return InventoryUtils.fitStackInSlot(new InventoryRange(inv), slot, stack);
    }

    public static int insertItem(InventoryRange inv, @Nonnull ItemStack stack, boolean simulate) {
        stack = stack.func_77946_l();
        for (int pass = 0; pass < 2; ++pass) {
            int[] nArray = inv.slots;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int fit;
                int slot;
                ItemStack base;
                if (pass == 0 == (base = inv.inv.func_70301_a(slot = nArray[i])).func_190926_b() || (fit = InventoryUtils.fitStackInSlot(inv, slot, stack)) == 0) continue;
                if (!base.func_190926_b()) {
                    stack.func_190918_g(fit);
                    if (!simulate) {
                        base.func_190917_f(fit);
                        inv.inv.func_70299_a(slot, base);
                    }
                } else {
                    if (!simulate) {
                        inv.inv.func_70299_a(slot, ItemUtils.copyStack(stack, fit));
                    }
                    stack.func_190918_g(fit);
                }
                if (stack.func_190916_E() != 0) continue;
                return 0;
            }
        }
        return stack.func_190916_E();
    }

    public static int insertItem(IInventory inv, @Nonnull ItemStack stack, boolean simulate) {
        return InventoryUtils.insertItem(new InventoryRange(inv), stack, simulate);
    }

    public static ItemStack getExtractableStack(InventoryRange inv, int slot) {
        ItemStack stack = inv.inv.func_70301_a(slot);
        if (stack.func_190926_b() || !inv.canExtractItem(slot, stack)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack getExtractableStack(IInventory inv, int slot) {
        return InventoryUtils.getExtractableStack(new InventoryRange(inv), slot);
    }

    public static boolean areStacksIdentical(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return stack1 == stack2;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && stack1.func_190916_E() == stack2.func_190916_E() && Objects.equal((Object)stack1.func_77978_p(), (Object)stack2.func_77978_p());
    }

    public static boolean canStack(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77973_b() == stack2.func_77973_b() && stack2.func_77952_i() == stack1.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && stack1.func_77985_e();
    }

    public static void consumeItem(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        Item item = stack.func_77973_b();
        if (item.hasContainerItem(stack)) {
            ItemStack container = item.getContainerItem(stack);
            inv.func_70299_a(slot, container);
        } else {
            inv.func_70298_a(slot, 1);
        }
    }

    public static int stackSize(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        return stack.func_190926_b() ? 0 : stack.func_190916_E();
    }

    public static void dropOnClose(PlayerEntity player, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70304_b(i);
            if (stack.func_190926_b()) continue;
            player.func_71019_a(stack, false);
        }
    }

    public static boolean canInsertStack(IItemHandler handler, int slot, ItemStack stack) {
        return handler.insertItem(slot, stack, true) != stack;
    }

    public static boolean canExtractStack(IItemHandler handler, int slot) {
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            return !handler.extractItem(slot, stack.func_77976_d(), true).func_190926_b();
        }
        return false;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack insert, boolean simulate) {
        insert = insert.func_77946_l();
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (pass == 0 && stack.func_190926_b()) continue;
                if (insert.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                insert = handler.insertItem(slot, insert, simulate);
            }
        }
        return insert;
    }

    public static int countMatchingStacks(IItemHandler handler, ItemStack filter, boolean insert) {
        int c = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b() || !ItemUtils.areStacksSameType(filter, stack) || !(insert ? InventoryUtils.canInsertStack(handler, slot, stack) : InventoryUtils.canExtractStack(handler, slot))) continue;
            c += stack.func_190916_E();
        }
        return c;
    }

    public static int getInsertableQuantity(IItemHandler handler, ItemStack stack) {
        ItemStack copy = ItemUtils.copyStack(stack, Integer.MAX_VALUE);
        int quantity = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (!InventoryUtils.canInsertStack(handler, slot, copy)) continue;
            ItemStack left = handler.insertItem(slot, copy, true);
            if (left.func_190926_b()) {
                quantity += copy.func_190916_E();
                continue;
            }
            quantity += copy.func_190916_E() - left.func_190916_E();
        }
        return quantity;
    }
}

