/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ThrowingBiConsumer;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface ConfigTag {
    public boolean hasParent();

    @Nullable
    public ConfigTag getParent();

    public boolean isCategory();

    public boolean isValue();

    public String getName();

    public String getQualifiedName();

    public boolean isDirty();

    public ConfigTag markDirty();

    public void clear();

    public boolean hasTag(String var1);

    public ConfigTag getTag(String var1);

    @Nullable
    public ConfigTag getTagIfPresent(String var1);

    public ConfigTag deleteTag(String var1);

    public List<String> getChildNames();

    public void walkTags(Consumer<ConfigTag> var1);

    public ConfigTag resetToDefault();

    public String getTagVersion();

    public ConfigTag setTagVersion(String var1);

    public TagType getTagType();

    public TagType getListType();

    default public ConfigTag setComment(String comment) {
        return this.setComment(comment.split("\n"));
    }

    default public ConfigTag setComment(String ... lines) {
        return this.setComment(Arrays.asList(lines));
    }

    public ConfigTag setComment(List<String> var1);

    public boolean getBoolean();

    public String getString();

    public int getInt();

    public long getLong();

    public int getHex();

    public double getDouble();

    public ConfigTag setDefaultBoolean(boolean var1);

    public ConfigTag setDefaultString(String var1);

    public ConfigTag setDefaultInt(int var1);

    public ConfigTag setDefaultLong(long var1);

    public ConfigTag setDefaultHex(int var1);

    public ConfigTag setDefaultDouble(double var1);

    public ConfigTag setBoolean(boolean var1);

    public ConfigTag setString(String var1);

    public ConfigTag setInt(int var1);

    public ConfigTag setLong(long var1);

    public ConfigTag setHex(int var1);

    public ConfigTag setDouble(double var1);

    public List<Boolean> getBooleanList();

    public List<String> getStringList();

    public List<Integer> getIntList();

    public List<Long> getLongList();

    public List<Integer> getHexList();

    public List<Double> getDoubleList();

    public ConfigTag setDefaultBooleanList(List<Boolean> var1);

    public ConfigTag setDefaultStringList(List<String> var1);

    public ConfigTag setDefaultIntList(List<Integer> var1);

    public ConfigTag setDefaultLongList(List<Long> var1);

    public ConfigTag setDefaultHexList(List<Integer> var1);

    public ConfigTag setDefaultDoubleList(List<Double> var1);

    public ConfigTag setBooleanList(List<Boolean> var1);

    public ConfigTag setStringList(List<String> var1);

    public ConfigTag setIntList(List<Integer> var1);

    public ConfigTag setLongList(List<Long> var1);

    public ConfigTag setHexList(List<Integer> var1);

    public ConfigTag setDoubleList(List<Double> var1);

    public ConfigTag copy();

    public ConfigTag copy(ConfigTag var1);

    public ConfigTag copyFrom(ConfigTag var1);

    public void save();

    public ConfigTag load();

    public ConfigTag setSyncToClient();

    public ConfigTag setSyncCallback(ThrowingBiConsumer<ConfigTag, SyncType, SyncException> var1);

    public boolean requiresSync();

    default public void runSync() {
        try {
            this.runSync(SyncType.MANUAL);
        }
        catch (SyncException e) {
            throw new RuntimeException("Sync exception caught on manual sync.", e);
        }
    }

    public void runSync(SyncType var1) throws SyncException;

    public void read(MCDataInput var1);

    public void write(MCDataOutput var1);

    public void readNetwork(MCDataInput var1);

    public void networkRestore();

    public Object getRawValue();

    public Object getSyncedValue();

    public static class SyncException
    extends Exception {
        public SyncException(String reason) {
            super(reason);
        }
    }

    public static enum SyncType {
        MANUAL,
        CONNECT,
        DISCONNECT;

    }

    public static enum TagType {
        BOOLEAN('B'){

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readBoolean();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeBoolean((Boolean)value);
            }
        }
        ,
        STRING('S'){

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readString();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeString((String)value);
            }
        }
        ,
        INT('I'){

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readSignedVarInt();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeSignedVarInt((Integer)value);
            }
        }
        ,
        LONG('L'){

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readSignedVarLong();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeSignedVarLong((Long)value);
            }
        }
        ,
        HEX('H'){

            @Override
            public String processLine(Object obj) {
                Integer hex = (Integer)obj;
                return "0x" + Long.toString((long)hex.intValue() << 32 >>> 32, 16).toUpperCase();
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return INT.read(in, listType);
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                INT.write(out, listType, value);
            }
        }
        ,
        DOUBLE('D'){

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readDouble();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeDouble((Double)value);
            }
        }
        ,
        LIST('#'){

            @Override
            public Object copy(Object value) {
                return new LinkedList((List)value);
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                LinkedList<Object> list = new LinkedList<Object>();
                int num = in.readVarInt();
                for (int i = 0; i < num; ++i) {
                    list.add(listType.read(in, null));
                }
                return list;
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                List list = (List)value;
                out.writeVarInt(list.size());
                for (Object o : list) {
                    listType.write(out, null, o);
                }
            }
        };

        private static final Char2ObjectMap<TagType> tagTypes;
        protected final char ch;

        private TagType(char ch) {
            this.ch = ch;
        }

        public char getChar() {
            return this.ch;
        }

        public Object copy(Object value) {
            return value;
        }

        public String processLine(Object obj) {
            return obj.toString();
        }

        public static TagType fromChar(char c) {
            return (TagType)((Object)tagTypes.getOrDefault(c, null));
        }

        public abstract Object read(MCDataInput var1, TagType var2);

        public abstract void write(MCDataOutput var1, TagType var2, Object var3);

        static {
            tagTypes = (Char2ObjectMap)Arrays.stream(TagType.values()).filter(e -> e != LIST).collect(Collectors.toMap(e -> Character.valueOf(e.ch), Function.identity(), (a, b) -> a, Char2ObjectArrayMap::new));
        }
    }
}

