/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.common.collect.HashMultimap;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Triple;

public class StructureHandler {
    private static final HashMultimap<ResourceLocation, Tuple<ResourceLocation, Setter>> STRUCTURE_PIECE_TO_TILE_MAP = HashMultimap.create();
    private static final Map<String, Tuple<ResourceLocation, Setter>> JIGSAW_TO_TILE_MAP = new HashMap<String, Tuple<ResourceLocation, Setter>>();
    private static final Map<ResourceLocation, Tuple<ResourceLocation, ITextComponent>> STRUCTURE_PIECE_TO_MARKER_MAP = new HashMap<ResourceLocation, Tuple<ResourceLocation, ITextComponent>>();
    private static final Map<ResourceLocation, Integer> STRUCTURE_PIECE_TILE_PRIORITY = new HashMap<ResourceLocation, Integer>();
    private static final Setter ALWAYS = (world, element, box) -> Collections.singleton(new ChunkPos(MathUtil.getCenter(box).func_177958_n() >> 4, MathUtil.getCenter(box).func_177952_p() >> 4));
    private static final Set<Triple<Integer, Integer, ResourceLocation>> VISITED_STRUCTURES = Collections.newSetFromMap(new ConcurrentHashMap());

    public static void registerTile(IStructurePieceType structurePieceType, int priority, ResourceLocation textureId, Setter setter) {
        ResourceLocation id = Registry.field_218362_C.func_177774_c((Object)structurePieceType);
        STRUCTURE_PIECE_TO_TILE_MAP.put((Object)id, (Object)new Tuple((Object)textureId, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(textureId, priority);
    }

    public static void registerTile(IStructurePieceType structurePieceType, int priority, ResourceLocation textureId) {
        StructureHandler.registerTile(structurePieceType, priority, textureId, ALWAYS);
    }

    public static void registerJigsawTile(String jigsawPattern, int priority, ResourceLocation tileID, Setter setter) {
        JIGSAW_TO_TILE_MAP.put(jigsawPattern, (Tuple<ResourceLocation, Setter>)new Tuple((Object)tileID, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(tileID, priority);
    }

    public static void registerJigsawTile(String jigsawPattern, int priority, ResourceLocation tileID) {
        StructureHandler.registerJigsawTile(jigsawPattern, priority, tileID, ALWAYS);
    }

    public static void registerMarker(Structure<?> structureFeature, ResourceLocation markerType, ITextComponent name) {
        STRUCTURE_PIECE_TO_MARKER_MAP.put(Registry.field_218361_B.func_177774_c(structureFeature), (Tuple<ResourceLocation, ITextComponent>)new Tuple((Object)markerType, (Object)name));
    }

    private static int getPriority(ResourceLocation structurePieceId) {
        return STRUCTURE_PIECE_TILE_PRIORITY.getOrDefault(structurePieceId, Integer.MAX_VALUE);
    }

    private static void put(World world, int chunkX, int chunkZ, ResourceLocation textureId) {
        ResourceLocation existingTile = AtlasAPI.getTileAPI().getGlobalTile(world, chunkX, chunkZ);
        if (StructureHandler.getPriority(textureId) < StructureHandler.getPriority(existingTile)) {
            AtlasAPI.getTileAPI().putGlobalTile(world, textureId, chunkX, chunkZ);
        }
    }

    private static void resolveJigsaw(StructurePiece jigsawPiece, ServerWorld world) {
        AbstractVillagePiece pool;
        if (jigsawPiece instanceof AbstractVillagePiece && (pool = (AbstractVillagePiece)jigsawPiece).func_214826_b() instanceof SingleJigsawPiece) {
            SingleJigsawPiece singlePoolElement = (SingleJigsawPiece)pool.func_214826_b();
            Optional left = singlePoolElement.field_236839_c_.left();
            if (left.isPresent()) {
                String path = ((ResourceLocation)left.get()).func_110623_a();
                for (Map.Entry<String, Tuple<ResourceLocation, Setter>> entry : JIGSAW_TO_TILE_MAP.entrySet()) {
                    ResourceLocation tile = (ResourceLocation)entry.getValue().func_76341_a();
                    Setter setter = (Setter)entry.getValue().func_76340_b();
                    if (!path.contains(entry.getKey())) continue;
                    for (ChunkPos pos : setter.matches((World)world, (JigsawPiece)singlePoolElement, pool.func_74874_b())) {
                        StructureHandler.put((World)world, pos.field_77276_a, pos.field_77275_b, tile);
                    }
                }
            }
        }
    }

    public static void resolve(StructurePiece structurePiece, ServerWorld world) {
        if (structurePiece.func_214807_k() == IStructurePieceType.field_242786_ad) {
            StructureHandler.resolveJigsaw(structurePiece, world);
            return;
        }
        ResourceLocation structurePieceId = Registry.field_218362_C.func_177774_c((Object)structurePiece.func_214807_k());
        if (STRUCTURE_PIECE_TO_TILE_MAP.containsKey((Object)structurePieceId)) {
            for (Tuple entry : STRUCTURE_PIECE_TO_TILE_MAP.get((Object)structurePieceId)) {
                Collection<ChunkPos> matches;
                if (structurePiece instanceof AbstractVillagePiece) {
                    AbstractVillagePiece pool = (AbstractVillagePiece)structurePiece;
                    matches = ((Setter)entry.func_76340_b()).matches((World)world, pool.func_214826_b(), pool.func_74874_b());
                } else {
                    matches = ((Setter)entry.func_76340_b()).matches((World)world, null, structurePiece.func_74874_b());
                }
                for (ChunkPos pos : matches) {
                    StructureHandler.put((World)world, pos.field_77276_a, pos.field_77275_b, (ResourceLocation)entry.func_76341_a());
                }
            }
        }
    }

    public static void resolve(StructureStart<?> structureStart, ServerWorld world) {
        ResourceLocation structureId = Registry.field_218361_B.func_177774_c((Object)structureStart.func_214627_k());
        if (STRUCTURE_PIECE_TO_MARKER_MAP.containsKey(structureId)) {
            Triple key = Triple.of((Object)structureStart.func_75071_a().func_215126_f().func_177958_n(), (Object)structureStart.func_75071_a().func_215126_f().func_177956_o(), (Object)structureId);
            if (VISITED_STRUCTURES.contains(key)) {
                return;
            }
            VISITED_STRUCTURES.add((Triple<Integer, Integer, ResourceLocation>)key);
            AtlasAPI.getMarkerAPI().putGlobalMarker((World)world, false, (ResourceLocation)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).func_76341_a(), (ITextComponent)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).func_76340_b(), structureStart.func_75071_a().func_215126_f().func_177958_n(), structureStart.func_75071_a().func_215126_f().func_177952_p());
        }
    }

    static interface Setter {
        public Collection<ChunkPos> matches(World var1, JigsawPiece var2, MutableBoundingBox var3);
    }
}

