/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class TileGroupsS2CPacket
extends S2CPacket {
    public static final int TILE_GROUPS_PER_PACKET = 100;
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "tile", "groups");
    int atlasID;
    RegistryKey<World> world;
    List<TileGroup> tileGroups;

    public TileGroupsS2CPacket(int atlasID, RegistryKey<World> world, List<TileGroup> tileGroups) {
        this.atlasID = atlasID;
        this.world = world;
        this.tileGroups = tileGroups;
    }

    public TileGroupsS2CPacket(PacketBuffer buf) {
        this.atlasID = buf.func_150792_a();
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        int length = buf.func_150792_a();
        this.tileGroups = new ArrayList<TileGroup>(length);
        for (int i = 0; i < length; ++i) {
            CompoundNBT tag = buf.func_150793_b();
            if (tag == null) continue;
            this.tileGroups.add(new TileGroup().readFromNBT(tag));
        }
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.TILE_GROUPS;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.atlasID);
        buf.func_192572_a(this.world.func_240901_a_());
        buf.func_150787_b(this.tileGroups.size());
        for (TileGroup tileGroup : this.tileGroups) {
            buf.func_150786_a(tileGroup.writeToNBT(new CompoundNBT()));
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            AtlasData atlasData = AntiqueAtlasMod.tileData.getData(this.atlasID, context.getPlayer().field_70170_p);
            WorldData dimData = atlasData.getWorldData(this.world);
            for (TileGroup t : this.tileGroups) {
                dimData.putTileGroup(t);
            }
        });
    }
}

