/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.AntiqueAtlasModClient;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Collection;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MarkersS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "marker", "info");
    private static final int GLOBAL = -1;
    int atlasID;
    RegistryKey<World> world;
    Collection<Marker> markers;
    ListMultimap<ResourceLocation, Marker.Precursor> markersByType;

    public MarkersS2CPacket(int atlasID, RegistryKey<World> world, Collection<Marker> markers) {
        this.atlasID = atlasID;
        this.world = world;
        this.markers = markers;
    }

    public MarkersS2CPacket(PacketBuffer buf) {
        this.atlasID = buf.func_150792_a();
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        int typesLength = buf.func_150792_a();
        this.markersByType = ArrayListMultimap.create();
        for (int i = 0; i < typesLength; ++i) {
            ResourceLocation type = buf.func_192575_l();
            int markersLength = buf.func_150792_a();
            for (int j = 0; j < markersLength; ++j) {
                this.markersByType.put((Object)type, (Object)new Marker.Precursor(buf));
            }
        }
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.MARKERS;
    }

    public void write(PacketBuffer buf) {
        ArrayListMultimap markersByType = ArrayListMultimap.create();
        for (Marker marker : this.markers) {
            markersByType.put((Object)marker.getType(), (Object)marker);
        }
        buf.func_150787_b(this.atlasID);
        buf.func_192572_a(this.world.func_240901_a_());
        buf.func_150787_b(markersByType.keySet().size());
        for (ResourceLocation type : markersByType.keySet()) {
            buf.func_192572_a(type);
            List markerList = markersByType.get((Object)type);
            buf.func_150787_b(markerList.size());
            for (Marker marker : markerList) {
                marker.write(buf);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            GlobalMarkersData markersData = this.atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, context.getPlayer().func_130014_f_());
            for (ResourceLocation type : this.markersByType.keys()) {
                MarkerType markerType = (MarkerType)MarkerType.REGISTRY.func_82594_a(type);
                for (Marker.Precursor precursor : this.markersByType.get((Object)type)) {
                    ((MarkersData)markersData).loadMarker(new Marker(MarkerType.REGISTRY.func_177774_c((Object)markerType), this.world, precursor));
                }
            }
            AntiqueAtlasModClient.getAtlasGUI().updateBookmarkerList();
        });
    }
}

