/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.Collection;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class DimensionUpdateS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "dimension", "update");
    int atlasID;
    RegistryKey<World> world;
    Collection<TileInfo> tiles;

    public DimensionUpdateS2CPacket(int atlasID, RegistryKey<World> world, Collection<TileInfo> tiles) {
        this.atlasID = atlasID;
        this.world = world;
        this.tiles = tiles;
    }

    public DimensionUpdateS2CPacket(PacketBuffer buf) {
        this.atlasID = buf.func_150792_a();
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        int tileCount = buf.func_150792_a();
        this.tiles = new ArrayList<TileInfo>();
        for (int i = 0; i < tileCount; ++i) {
            this.tiles.add(new TileInfo(buf.func_150792_a(), buf.func_150792_a(), buf.func_192575_l()));
        }
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.DIMENSION_UPDATE;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.atlasID);
        buf.func_192572_a(this.world.func_240901_a_());
        buf.func_150787_b(this.tiles.size());
        for (TileInfo tile : this.tiles) {
            buf.func_150787_b(tile.x);
            buf.func_150787_b(tile.z);
            buf.func_192572_a(tile.id);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            AtlasData data = AntiqueAtlasMod.tileData.getData(this.atlasID, context.getPlayer().func_130014_f_());
            for (TileInfo info : this.tiles) {
                data.getWorldData(this.world).setTile(info.x, info.z, info.id);
            }
        });
    }
}

