/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.TileDataStorage;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.List;
import java.util.Map;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class CustomTileInfoS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "custom_tile", "info");
    RegistryKey<World> world;
    List<Map.Entry<ChunkPos, ResourceLocation>> tiles;
    int chunkX;
    int chunkZ;
    ResourceLocation tileId;

    public CustomTileInfoS2CPacket(RegistryKey<World> world, List<Map.Entry<ChunkPos, ResourceLocation>> tiles) {
        this.world = world;
        this.tiles = tiles;
    }

    public CustomTileInfoS2CPacket(RegistryKey<World> world, int chunkX, int chunkZ, ResourceLocation tileId) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.tileId = tileId;
    }

    public CustomTileInfoS2CPacket(PacketBuffer buf) {
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        int tileCount = buf.func_150792_a();
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(this.world);
        for (int i = 0; i < tileCount; ++i) {
            data.setTile(buf.func_150792_a(), buf.func_150792_a(), buf.func_192575_l());
        }
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.CUSTOM_TILE_INFO;
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.world.func_240901_a_());
        if (this.tiles != null) {
            buf.func_150787_b(this.tiles.size());
            for (Map.Entry<ChunkPos, ResourceLocation> entry : this.tiles) {
                buf.func_150787_b(entry.getKey().field_77276_a);
                buf.func_150787_b(entry.getKey().field_77275_b);
                buf.func_192572_a(entry.getValue());
            }
        } else {
            buf.func_150787_b(1);
            buf.func_150787_b(this.chunkX);
            buf.func_150787_b(this.chunkZ);
            buf.func_192572_a(this.tileId);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
    }
}

