/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class AddMarkerC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "marker", "add");
    int atlasID;
    ResourceLocation markerType;
    int x;
    int z;
    boolean visibleBeforeDiscovery;
    ITextComponent label;

    public AddMarkerC2SPacket(int atlasID, ResourceLocation markerType, int x, int z, boolean visibleBeforeDiscovery, ITextComponent label) {
        this.atlasID = atlasID;
        this.markerType = markerType;
        this.x = x;
        this.z = z;
        this.visibleBeforeDiscovery = visibleBeforeDiscovery;
        this.label = label;
    }

    public AddMarkerC2SPacket(PacketBuffer buf) {
        this.atlasID = buf.func_150792_a();
        this.markerType = buf.func_192575_l();
        this.x = buf.func_150792_a();
        this.z = buf.func_150792_a();
        this.visibleBeforeDiscovery = buf.readBoolean();
        this.label = buf.func_179258_d();
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.ADD_MARKER;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.atlasID);
        buf.func_192572_a(this.markerType);
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.z);
        buf.writeBoolean(this.visibleBeforeDiscovery);
        buf.func_179256_a(this.label);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (!AtlasAPI.getPlayerAtlases(context.getPlayer()).contains(this.atlasID)) {
                AntiqueAtlasMod.LOG.warn("Player {} attempted to put marker into someone else's Atlas #{}}", (Object)context.getPlayer().func_200200_C_(), (Object)this.atlasID);
                return;
            }
            AtlasAPI.getMarkerAPI().putMarker(context.getPlayer().field_70170_p, this.visibleBeforeDiscovery, this.atlasID, this.markerType, this.label, this.x, this.z);
        });
    }
}

