/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class Marker {
    private final int id;
    private final ResourceLocation type;
    private final ITextComponent label;
    private final RegistryKey<World> world;
    private final int x;
    private final int z;
    private final boolean visibleAhead;
    private boolean isGlobal;

    public Marker(int id, ResourceLocation type, ITextComponent label, RegistryKey<World> world, int x, int z, boolean visibleAhead) {
        this.id = id;
        this.type = type;
        this.label = label;
        this.world = world;
        this.x = x;
        this.z = z;
        this.visibleAhead = visibleAhead;
    }

    public Marker(ResourceLocation type, RegistryKey<World> world, Precursor precursor) {
        this(precursor.id, type, precursor.label, world, precursor.x, precursor.z, precursor.visibleAhead);
    }

    public int getId() {
        return this.id;
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public ITextComponent getLabel() {
        return this.label;
    }

    public RegistryKey<World> getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    public boolean isVisibleAhead() {
        return this.visibleAhead;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    Marker setGlobal(boolean value) {
        this.isGlobal = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)obj;
        return this.id == marker.id;
    }

    public ChunkPos getChunkCoords() {
        return new ChunkPos(new BlockPos(this.x, 0, this.z));
    }

    public String toString() {
        return "#" + this.id + "\"" + this.label.getString() + "\"@(" + this.x + ", " + this.z + ")";
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.id);
        buf.func_179256_a(this.label);
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.z);
        buf.writeBoolean(this.visibleAhead);
    }

    public static class Precursor {
        private final int id;
        private final ITextComponent label;
        private final int x;
        private final int z;
        private final boolean visibleAhead;

        public Precursor(PacketBuffer buf) {
            this.id = buf.func_150792_a();
            this.label = buf.func_179258_d();
            this.x = buf.func_150792_a();
            this.z = buf.func_150792_a();
            this.visibleAhead = buf.readBoolean();
        }
    }
}

