/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorEnd;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorNether;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;

public class WorldScanner {
    private final Map<RegistryKey<World>, ITileDetector> biomeAnalyzers = new HashMap<RegistryKey<World>, ITileDetector>();
    private final TileDetectorBase tileDetectorOverworld = new TileDetectorBase();

    public WorldScanner() {
        this.setBiomeDetectorForWorld((RegistryKey<World>)World.field_234918_g_, this.tileDetectorOverworld);
        this.setBiomeDetectorForWorld((RegistryKey<World>)World.field_234919_h_, new TileDetectorNether());
        this.setBiomeDetectorForWorld((RegistryKey<World>)World.field_234920_i_, new TileDetectorEnd());
    }

    private ITileDetector getBiomeDetectorForWorld(RegistryKey<World> world) {
        ITileDetector biomeAnalyzer = this.biomeAnalyzers.get(world);
        return biomeAnalyzer == null ? this.tileDetectorOverworld : biomeAnalyzer;
    }

    private void setBiomeDetectorForWorld(RegistryKey<World> world, ITileDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(world, biomeAnalyzer);
    }

    public Collection<TileInfo> updateAtlasAroundPlayer(AtlasData data, PlayerEntity player) {
        int newScanInterval = Math.round(AntiqueAtlasMod.CONFIG.newScanInterval * 20.0f);
        if (player.func_130014_f_().func_82737_E() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int rescanInterval = newScanInterval * AntiqueAtlasMod.CONFIG.rescanRate;
        boolean rescanRequired = AntiqueAtlasMod.CONFIG.doRescan && player.func_130014_f_().func_82737_E() % (long)rescanInterval == 0L;
        ITileDetector biomeDetector = this.getBiomeDetectorForWorld((RegistryKey<World>)player.func_130014_f_().func_234923_W_());
        int scanRadius = biomeDetector.getScanRadius();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                if (dx * dx + dz * dz > scanRadius * scanRadius) continue;
                int chunkX = player.field_70176_ah + dx;
                int chunkZ = player.field_70164_aj + dz;
                TileInfo update = this.updateAtlasForChunk(data, player.func_130014_f_(), chunkX, chunkZ, rescanRequired);
                if (update == null) continue;
                updatedTiles.add(update);
            }
        }
        return updatedTiles;
    }

    private TileInfo updateAtlasForChunk(AtlasData data, World world, int x, int z, boolean rescanRequired) {
        WorldData storedData = data.getWorldData((RegistryKey<World>)world.func_234923_W_());
        ResourceLocation oldTile = storedData.getTile(x, z);
        ResourceLocation tile = AtlasAPI.getTileAPI().getGlobalTile(world, x, z);
        if (tile == null) {
            if (oldTile != null && !rescanRequired) {
                return null;
            }
            IChunk chunk = world.func_217353_a(x, z, ChunkStatus.field_222617_m, AntiqueAtlasMod.CONFIG.forceChunkLoading);
            if (chunk == null) {
                return null;
            }
            ITileDetector biomeDetector = this.getBiomeDetectorForWorld((RegistryKey<World>)world.func_234923_W_());
            tile = biomeDetector.getBiomeID(world, chunk);
            if (oldTile != null) {
                if (tile == null) {
                    data.removeTile((RegistryKey<World>)world.func_234923_W_(), x, z);
                } else if (!oldTile.equals((Object)tile)) {
                    data.setTile((RegistryKey<World>)world.func_234923_W_(), x, z, tile);
                    return new TileInfo(x, z, tile);
                }
            } else if (tile != null) {
                data.setTile((RegistryKey<World>)world.func_234923_W_(), x, z, tile);
                return new TileInfo(x, z, tile);
            }
        } else if (oldTile == null || !oldTile.equals((Object)tile)) {
            data.setTile((RegistryKey<World>)world.func_234923_W_(), x, z, tile);
            data.func_76185_a();
            return new TileInfo(x, z, tile);
        }
        return null;
    }
}

