/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import slimeknights.mantle.Mantle;

public class TileEntityHelper {
    public static <T> Optional<T> getTile(Class<T> clazz, @Nullable IBlockReader world, BlockPos pos) {
        return TileEntityHelper.getTile(clazz, world, pos, false);
    }

    public static <T> Optional<T> getTile(Class<T> clazz, @Nullable IBlockReader world, BlockPos pos, boolean logWrongType) {
        if (!TileEntityHelper.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return Optional.empty();
        }
        if (clazz.isInstance(tile)) {
            return Optional.of(clazz.cast(tile));
        }
        if (logWrongType) {
            Mantle.logger.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, clazz, tile.getClass());
        }
        return Optional.empty();
    }

    public static boolean isBlockLoaded(@Nullable IBlockReader world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof IWorldReader) {
            return ((IWorldReader)world).func_175667_e(pos);
        }
        return true;
    }

    private TileEntityHelper() {
    }
}

