/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import slimeknights.mantle.recipe.TagPreference;

public abstract class ItemOutput
implements Supplier<ItemStack> {
    @Override
    public abstract ItemStack get();

    public abstract JsonElement serialize();

    public static ItemOutput fromStack(ItemStack stack) {
        return new OfStack(stack);
    }

    public static ItemOutput fromItem(IItemProvider item, int count) {
        return new OfItem(item.func_199767_j(), count);
    }

    public static ItemOutput fromItem(IItemProvider item) {
        return ItemOutput.fromItem(item, 1);
    }

    public static ItemOutput fromTag(ITag<Item> tag, int count) {
        return new OfTagPreference(tag, count);
    }

    public static ItemOutput fromJson(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return ItemOutput.fromItem((IItemProvider)JSONUtils.func_188172_b((JsonElement)element, (String)"item"));
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Invalid item output, must be a string or an object");
        }
        JsonObject json = element.getAsJsonObject();
        if (json.has("tag")) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"tag");
            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(name));
            if (tag == null) {
                throw new JsonSyntaxException("Unknown tag " + name + " for item output");
            }
            int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
            return ItemOutput.fromTag((ITag<Item>)tag, count);
        }
        return ItemOutput.fromStack(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150788_a(this.get());
    }

    public static ItemOutput read(PacketBuffer buffer) {
        return ItemOutput.fromStack(buffer.func_150791_c());
    }

    private static class OfTagPreference
    extends ItemOutput {
        private final ITag<Item> tag;
        private final int count;
        private ItemStack cachedResult = null;

        @Override
        public ItemStack get() {
            if (this.cachedResult == null) {
                this.cachedResult = TagPreference.getItems().getPreference(this.tag).map(item -> new ItemStack((IItemProvider)item, this.count)).orElse(ItemStack.field_190927_a);
            }
            return this.cachedResult;
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("tag", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.tag).toString());
            if (this.count != 1) {
                json.addProperty("count", (Number)this.count);
            }
            return json;
        }

        public OfTagPreference(ITag<Item> tag, int count) {
            this.tag = tag;
            this.count = count;
        }
    }

    private static class OfStack
    extends ItemOutput {
        private final ItemStack stack;

        @Override
        public ItemStack get() {
            return this.stack;
        }

        @Override
        public JsonElement serialize() {
            String itemName = Objects.requireNonNull(this.stack.func_77973_b().getRegistryName()).toString();
            int count = this.stack.func_190916_E();
            if (this.stack.func_77942_o() || count > 1) {
                CompoundNBT nbt;
                JsonObject jsonResult = new JsonObject();
                jsonResult.addProperty("item", itemName);
                if (count > 1) {
                    jsonResult.addProperty("count", (Number)count);
                }
                if ((nbt = this.stack.func_77978_p()) != null) {
                    jsonResult.addProperty("nbt", nbt.toString());
                }
                return jsonResult;
            }
            return new JsonPrimitive(itemName);
        }

        public OfStack(ItemStack stack) {
            this.stack = stack;
        }
    }

    private static class OfItem
    extends ItemOutput {
        private final Item item;
        private final int count;
        private ItemStack cachedStack;

        @Override
        public ItemStack get() {
            if (this.cachedStack == null) {
                this.cachedStack = new ItemStack((IItemProvider)this.item, this.count);
            }
            return this.cachedStack;
        }

        @Override
        public JsonElement serialize() {
            String itemName = Objects.requireNonNull(this.item.getRegistryName()).toString();
            if (this.count > 1) {
                JsonObject json = new JsonObject();
                json.addProperty("item", itemName);
                json.addProperty("count", (Number)this.count);
                return json;
            }
            return new JsonPrimitive(itemName);
        }

        public OfItem(Item item, int count) {
            this.item = item;
            this.count = count;
        }
    }
}

