/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.List;
import java.util.Objects;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.TagCollectionArgument;

public class ViewTagCommand {
    private static final ITextComponent EMPTY = new TranslationTextComponent("command.mantle.tag.empty");
    protected static final Dynamic2CommandExceptionType TAG_NOT_FOUND = new Dynamic2CommandExceptionType((type, name) -> new TranslationTextComponent("command.mantle.tag.not_found", new Object[]{type, name}));

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(Commands.func_197056_a((String)"type", (ArgumentType)TagCollectionArgument.collection()).then(Commands.func_197056_a((String)"name", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(MantleCommand.VALID_TAGS).executes(ViewTagCommand::run)));
    }

    private static int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TagCollectionArgument.Result result = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        ITag tag = result.getCollection().func_199910_a(name);
        if (tag != null) {
            TranslationTextComponent output = new TranslationTextComponent("command.mantle.view_tag.success", new Object[]{result.getName(), name});
            List values = tag.func_230236_b_();
            if (values.isEmpty()) {
                output.func_240702_b_("\n* ").func_230529_a_(EMPTY);
            } else {
                values.stream().filter(value -> value instanceof IForgeRegistryEntry).map(value -> (IForgeRegistryEntry)value).sorted((a, b) -> Objects.requireNonNull(a.getRegistryName()).compareNamespaced(Objects.requireNonNull(b.getRegistryName()))).forEach(arg_0 -> ViewTagCommand.lambda$run$5((IFormattableTextComponent)output, arg_0));
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)output, true);
            return values.size();
        }
        throw TAG_NOT_FOUND.create((Object)result.getName(), (Object)name);
    }

    private static /* synthetic */ void lambda$run$5(IFormattableTextComponent output, IForgeRegistryEntry value) {
        output.func_240702_b_("\n* " + Objects.requireNonNull(value.getRegistryName()).toString());
    }
}

