/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.Mantle;

public class SimpleBlockModel
implements IModelGeometry<SimpleBlockModel> {
    public static final Loader LOADER = new Loader();
    private static final ResourceLocation BAKE_LOCATION = Mantle.getResource("dynamic_model_baking");
    @Nullable
    private ResourceLocation parentLocation;
    private final List<BlockPart> parts;
    private final Map<String, Either<RenderMaterial, String>> textures;
    private BlockModel parent;

    public SimpleBlockModel(@Nullable ResourceLocation parentLocation, Map<String, Either<RenderMaterial, String>> textures, List<BlockPart> parts) {
        this.parts = parts;
        this.textures = textures;
        this.parentLocation = parentLocation;
    }

    public List<BlockPart> getElements() {
        return this.parts.isEmpty() && this.parent != null ? this.parent.func_178298_a() : this.parts;
    }

    public void fetchParent(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter) {
        if (this.parent != null || this.parentLocation == null) {
            return;
        }
        LinkedHashSet chain = Sets.newLinkedHashSet();
        this.parent = SimpleBlockModel.getParent(modelGetter, chain, this.parentLocation, owner.getModelName());
        if (this.parent == null) {
            this.parent = SimpleBlockModel.getMissing(modelGetter);
            this.parentLocation = ModelBakery.field_177604_a;
        }
        BlockModel link = this.parent;
        while (link.field_178316_e != null && link.field_178315_d == null) {
            chain.add(link);
            link.field_178315_d = SimpleBlockModel.getParent(modelGetter, chain, link.field_178316_e, link.field_178317_b);
            if (link.field_178315_d == null) {
                link.field_178315_d = SimpleBlockModel.getMissing(modelGetter);
                link.field_178316_e = ModelBakery.field_177604_a;
            }
            link = link.field_178315_d;
        }
    }

    @Nullable
    private static BlockModel getParent(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<IUnbakedModel> chain, ResourceLocation location, String name) {
        IUnbakedModel unbaked = modelGetter.apply(location);
        if (unbaked == null) {
            Mantle.logger.warn("No parent '{}' while loading model '{}'", (Object)location, (Object)name);
            return null;
        }
        if (chain.contains(unbaked)) {
            Mantle.logger.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)name, (Object)chain.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)location);
            return null;
        }
        if (!(unbaked instanceof BlockModel)) {
            throw new IllegalStateException("BlockModel parent has to be a block model.");
        }
        return (BlockModel)unbaked;
    }

    @Nonnull
    private static BlockModel getMissing(Function<ResourceLocation, IUnbakedModel> modelGetter) {
        IUnbakedModel model = modelGetter.apply((ResourceLocation)ModelBakery.field_177604_a);
        if (!(model instanceof BlockModel)) {
            throw new IllegalStateException("Failed to load missing model");
        }
        return (BlockModel)model;
    }

    public static Collection<RenderMaterial> getTextures(IModelConfiguration owner, List<BlockPart> elements, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet((Object[])new RenderMaterial[]{owner.resolveTexture("particle")});
        for (BlockPart part : elements) {
            for (BlockPartFace face : part.field_178240_c.values()) {
                RenderMaterial material = owner.resolveTexture(face.field_178242_d);
                if (Objects.equals(material.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                }
                textures.add(material);
            }
        }
        return textures;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.fetchParent(owner, modelGetter);
        return SimpleBlockModel.getTextures(owner, this.getElements(), missingTextureErrors);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IModelConfiguration owner, BlockPart part, IModelTransform transform, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        for (Direction direction : part.field_178240_c.keySet()) {
            BlockPartFace face = (BlockPartFace)part.field_178240_c.get(direction);
            String texture = face.field_178242_d;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(texture));
            BakedQuad bakedQuad = BlockModel.func_228812_a_((BlockPart)part, (BlockPartFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)transform, (ResourceLocation)location);
            if (face.field_178244_b == null) {
                builder.func_177648_a(bakedQuad);
                continue;
            }
            builder.func_177650_a(Direction.func_229385_a_((Matrix4f)transform.func_225615_b_().func_227988_c_(), (Direction)face.field_178244_b), bakedQuad);
        }
    }

    public static IBakedModel bakeModel(IModelConfiguration owner, List<BlockPart> elements, IModelTransform transform, ItemOverrideList overrides, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(owner, overrides).func_177646_a(particle);
        for (BlockPart part : elements) {
            SimpleBlockModel.bakePart(builder, owner, part, transform, spriteGetter, location);
        }
        return builder.func_177645_b();
    }

    public static IBakedModel bakeDynamic(IModelConfiguration owner, List<BlockPart> elements, IModelTransform transform) {
        return SimpleBlockModel.bakeModel(owner, elements, transform, ItemOverrideList.field_188022_a, ModelLoader.defaultTextureGetter(), BAKE_LOCATION);
    }

    public IBakedModel bakeModel(IModelConfiguration owner, IModelTransform transform, ItemOverrideList overrides, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        return SimpleBlockModel.bakeModel(owner, this.getElements(), transform, overrides, spriteGetter, location);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        return this.bakeModel(owner, transform, overrides, spriteGetter, location);
    }

    public IBakedModel bakeDynamic(IModelConfiguration owner, IModelTransform transform) {
        return SimpleBlockModel.bakeDynamic(owner, this.getElements(), transform);
    }

    public static SimpleBlockModel deserialize(JsonDeserializationContext context, JsonObject json) {
        ImmutableMap textureMap;
        ResourceLocation parent;
        String parentName = JSONUtils.func_151219_a((JsonObject)json, (String)"parent", (String)"");
        ResourceLocation resourceLocation = parent = parentName.isEmpty() ? null : new ResourceLocation(parentName);
        if (json.has("textures")) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            ResourceLocation atlas = PlayerContainer.field_226615_c_;
            JsonObject textures = JSONUtils.func_152754_s((JsonObject)json, (String)"textures");
            for (Map.Entry entry : textures.entrySet()) {
                builder.put(entry.getKey(), (Object)BlockModel.Deserializer.func_228819_a_((ResourceLocation)atlas, (String)((JsonElement)entry.getValue()).getAsString()));
            }
            textureMap = builder.build();
        } else {
            textureMap = Collections.emptyMap();
        }
        List<Object> parts = json.has("elements") ? SimpleBlockModel.getModelElements(context, (JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"elements"), "elements") : Collections.emptyList();
        return new SimpleBlockModel(parent, (Map<String, Either<RenderMaterial, String>>)textureMap, (List<BlockPart>)parts);
    }

    public static List<BlockPart> getModelElements(JsonDeserializationContext context, JsonElement array, String name) {
        if (array.isJsonObject()) {
            return ImmutableList.of((Object)context.deserialize((JsonElement)array.getAsJsonObject(), BlockPart.class));
        }
        if (array.isJsonArray()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement json : array.getAsJsonArray()) {
                builder.add((Object)((BlockPart)context.deserialize(json, BlockPart.class)));
            }
            return builder.build();
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a JsonArray or JsonObject");
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public Map<String, Either<RenderMaterial, String>> getTextures() {
        return this.textures;
    }

    public BlockModel getParent() {
        return this.parent;
    }

    private static class Loader
    implements IModelLoader<SimpleBlockModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public SimpleBlockModel read(JsonDeserializationContext context, JsonObject json) {
            return SimpleBlockModel.deserialize(context, json);
        }
    }
}

