/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.lang3.tuple.Pair;

public class ModelHelper {
    private static final Map<Block, ResourceLocation> TEXTURE_NAME_CACHE = new HashMap<Block, ResourceLocation>();
    public static final ISelectiveResourceReloadListener LISTENER = (manager, predicate) -> {
        if (predicate.test(VanillaResourceType.MODELS)) {
            TEXTURE_NAME_CACHE.clear();
        }
    };

    @Nullable
    public static <T extends IBakedModel> T getBakedModel(BlockState state, Class<T> clazz) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            return null;
        }
        IBakedModel baked = minecraft.func_209506_al().func_174954_c().func_178125_b(state);
        if (baked instanceof MultipartBakedModel) {
            baked = (IBakedModel)((Pair)((MultipartBakedModel)baked).field_188626_f.get(0)).getRight();
        }
        if (baked instanceof WeightedBakedModel) {
            baked = ((WeightedBakedModel)baked).field_177566_c;
        }
        if (clazz.isInstance(baked)) {
            return (T)((IBakedModel)clazz.cast(baked));
        }
        return null;
    }

    @Nullable
    public static <T extends IBakedModel> T getBakedModel(IItemProvider item, Class<T> clazz) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            return null;
        }
        IBakedModel baked = minecraft.func_175599_af().func_175037_a().func_199312_b(item.func_199767_j());
        if (clazz.isInstance(baked)) {
            return (T)((IBakedModel)clazz.cast(baked));
        }
        return null;
    }

    private static ResourceLocation getParticleTextureInternal(Block block) {
        return Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(block.func_176223_P()).func_177554_e().func_195668_m();
    }

    public static ResourceLocation getParticleTexture(Block block) {
        return TEXTURE_NAME_CACHE.computeIfAbsent(block, ModelHelper::getParticleTextureInternal);
    }

    public static <T> T arrayToObject(JsonObject json, String name, int size, Function<float[], T> mapper) {
        JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)name);
        if (array.size() != size) {
            throw new JsonParseException("Expected " + size + " " + name + " values, found: " + array.size());
        }
        float[] vec = new float[size];
        for (int i = 0; i < size; ++i) {
            vec[i] = JSONUtils.func_151220_d((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return mapper.apply(vec);
    }

    public static Vector3f arrayToVector(JsonObject json, String name) {
        return ModelHelper.arrayToObject(json, name, 3, arr -> new Vector3f(arr[0], arr[1], arr[2]));
    }

    public static int getRotation(JsonObject json, String key) {
        int i = JSONUtils.func_151208_a((JsonObject)json, (String)key, (int)0);
        if (i >= 0 && i % 90 == 0 && i / 90 <= 3) {
            return i;
        }
        throw new JsonParseException("Invalid '" + key + "' " + i + " found, only 0/90/180/270 allowed");
    }

    public static BakedQuad colorQuad(int color, BakedQuad quad) {
        ColorTransformer transformer = new ColorTransformer(color, quad);
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    private ModelHelper() {
    }

    private static class ColorTransformer
    extends VertexTransformer {
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public ColorTransformer(int color, BakedQuad quad) {
            super((IVertexConsumer)new BakedQuadBuilder(quad.func_187508_a()));
            int a = color >> 24;
            if (a == 0) {
                a = 255;
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
            this.a = (float)a / 255.0f;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.Usage usage = ((VertexFormatElement)this.parent.getVertexFormat().func_227894_c_().get(element)).func_177375_c();
            if (usage == VertexFormatElement.Usage.COLOR && data.length >= 4) {
                data[0] = this.r;
                data[1] = this.g;
                data[2] = this.b;
                data[3] = this.a;
            }
            super.put(element, data);
        }

        public BakedQuad build() {
            return ((BakedQuadBuilder)this.parent).build();
        }
    }
}

