/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.structure.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.lighting.WorldLightManager;
import slimeknights.mantle.client.book.structure.world.TemplateChunk;

public class TemplateChunkProvider
extends AbstractChunkProvider {
    private final Map<ChunkPos, IChunk> chunks;
    private final World world;
    private final WorldLightManager lightManager;

    public TemplateChunkProvider(List<Template.BlockInfo> blocks, World world, Predicate<BlockPos> shouldShow) {
        this.world = world;
        this.lightManager = new WorldLightManager((IChunkLightProvider)this, true, true);
        HashMap<ChunkPos, List> byChunk = new HashMap<ChunkPos, List>();
        for (Template.BlockInfo info : blocks) {
            byChunk.computeIfAbsent(new ChunkPos(info.field_186242_a), $ -> new ArrayList()).add(info);
        }
        this.chunks = byChunk.entrySet().stream().map(e -> Pair.of(e.getKey(), (Object)((Object)new TemplateChunk(world, (ChunkPos)e.getKey(), (List)e.getValue(), shouldShow)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Nullable
    public IChunk func_212849_a_(int chunkX, int chunkZ, @Nonnull ChunkStatus requiredStatus, boolean load) {
        return this.chunks.computeIfAbsent(new ChunkPos(chunkX, chunkZ), p -> new EmptyChunk(this.world, p));
    }

    @Nonnull
    public String func_73148_d() {
        return "?";
    }

    @Nonnull
    public WorldLightManager func_212863_j_() {
        return this.lightManager;
    }

    @Nonnull
    public IBlockReader func_212864_k_() {
        return this.world;
    }
}

