/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import slimeknights.mantle.config.Config;

@OnlyIn(value=Dist.CLIENT)
public class ExtraHeartRenderHandler {
    private static final ResourceLocation ICON_HEARTS = new ResourceLocation("mantle", "textures/gui/hearts.png");
    private static final ResourceLocation ICON_ABSORB = new ResourceLocation("mantle", "textures/gui/absorb.png");
    private static final ResourceLocation ICON_VANILLA = AbstractGui.field_230665_h_;
    private final Minecraft mc = Minecraft.func_71410_x();
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private final Random rand = new Random();
    private int regen;

    private void blit(MatrixStack matrixStack, int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.func_238474_b_(matrixStack, x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        boolean highlight;
        Entity renderViewEnity = this.mc.func_175606_aa();
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled() || !Config.EXTRA_HEART_RENDERER.getAsBoolean() || !(renderViewEnity instanceof PlayerEntity)) {
            return;
        }
        int left_height = ForgeIngameGui.left_height;
        int width = this.mc.func_228018_at_().func_198107_o();
        int height = this.mc.func_228018_at_().func_198087_p();
        int updateCounter = this.mc.field_71456_v.func_73834_c();
        this.mc.func_213239_aq().func_76320_a("health");
        RenderSystem.enableBlend();
        PlayerEntity player = (PlayerEntity)renderViewEnity;
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Util.func_211177_b();
            this.healthUpdateCounter = updateCounter + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Util.func_211177_b();
            this.healthUpdateCounter = updateCounter + 10;
        }
        if (Util.func_211177_b() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Util.func_211177_b();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        ModifiableAttributeInstance attrMaxHealth = player.func_110148_a(Attributes.field_233818_a_);
        float healthMax = attrMaxHealth == null ? 0.0f : (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        healthMax = Math.min(healthMax, 20.0f);
        health = Math.min(health, 20);
        absorb = Math.min(absorb, 20.0f);
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(updateCounter * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        this.regen = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            this.regen = updateCounter % 25;
        }
        assert (this.mc.field_71441_e != null);
        int TOP = 9 * (this.mc.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(Effects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(Effects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        MatrixStack matrixStack = event.getMatrixStack();
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == this.regen) {
                y -= 2;
            }
            this.blit(matrixStack, x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.blit(matrixStack, x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.blit(matrixStack, x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.blit(matrixStack, x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.blit(matrixStack, x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.blit(matrixStack, x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.blit(matrixStack, x, y, MARGIN + 45, TOP, 9, 9);
        }
        this.renderExtraHearts(matrixStack, left, top, player);
        this.renderExtraAbsorption(matrixStack, left, top - rowHeight, player);
        this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
        ForgeIngameGui.left_height += 10;
        if (absorb > 0.0f) {
            ForgeIngameGui.left_height += 10;
        }
        event.setCanceled(true);
        RenderSystem.disableBlend();
        this.mc.func_213239_aq().func_76319_b();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(matrixStack, (RenderGameOverlayEvent)event, RenderGameOverlayEvent.ElementType.HEALTH));
    }

    private int getPotionOffset(PlayerEntity player) {
        int potionOffset = 0;
        EffectInstance potion = player.func_70660_b(Effects.field_82731_v);
        if (potion != null) {
            potionOffset = 18;
        }
        if ((potion = player.func_70660_b(Effects.field_76436_u)) != null) {
            potionOffset = 9;
        }
        assert (this.mc.field_71441_e != null);
        if (this.mc.field_71441_e.func_72912_H().func_76093_s()) {
            potionOffset += 27;
        }
        return potionOffset;
    }

    private void renderExtraHearts(MatrixStack matrixStack, int xBasePos, int yBasePos, PlayerEntity player) {
        int potionOffset = this.getPotionOffset(player);
        this.mc.func_110434_K().func_110577_a(ICON_HEARTS);
        int hp = MathHelper.func_76123_f((float)player.func_110143_aJ());
        this.renderCustomHearts(matrixStack, xBasePos, yBasePos, potionOffset, hp, false);
    }

    private void renderExtraAbsorption(MatrixStack matrixStack, int xBasePos, int yBasePos, PlayerEntity player) {
        int potionOffset = this.getPotionOffset(player);
        this.mc.func_110434_K().func_110577_a(ICON_ABSORB);
        int absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        this.renderCustomHearts(matrixStack, xBasePos, yBasePos, potionOffset, absorb, true);
    }

    private int getYRegenOffset(int i, int offset) {
        return i + offset == this.regen ? -2 : 0;
    }

    private void renderCustomHearts(MatrixStack matrixStack, int xBasePos, int yBasePos, int potionOffset, int count, boolean absorb) {
        int regenOffset = absorb ? 10 : 0;
        for (int iter = 0; iter < count / 20; ++iter) {
            int renderHearts = (count - 20 * (iter + 1)) / 2;
            int heartIndex = iter % 11;
            if (renderHearts > 10) {
                renderHearts = 10;
            }
            for (int i = 0; i < renderHearts; ++i) {
                int y = this.getYRegenOffset(i, regenOffset);
                if (absorb) {
                    this.blit(matrixStack, xBasePos + 8 * i, yBasePos + y, 0, 54, 9, 9);
                }
                this.blit(matrixStack, xBasePos + 8 * i, yBasePos + y, 18 * heartIndex, potionOffset, 9, 9);
            }
            if (count % 2 != 1 || renderHearts >= 10) continue;
            int y = this.getYRegenOffset(renderHearts, regenOffset);
            if (absorb) {
                this.blit(matrixStack, xBasePos + 8 * renderHearts, yBasePos + y, 0, 54, 9, 9);
            }
            this.blit(matrixStack, xBasePos + 8 * renderHearts, yBasePos + y, 9 + 18 * heartIndex, potionOffset, 9, 9);
        }
    }
}

