/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TextFieldBuilder
extends AbstractFieldBuilder<String, StringListEntry, TextFieldBuilder> {
    public TextFieldBuilder(ITextComponent resetButtonKey, ITextComponent fieldNameKey, String value) {
        super(resetButtonKey, fieldNameKey);
        Objects.requireNonNull(value);
        this.value = value;
    }

    @Override
    public TextFieldBuilder setErrorSupplier(Function<String, Optional<ITextComponent>> errorSupplier) {
        return (TextFieldBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public TextFieldBuilder requireRestart() {
        return (TextFieldBuilder)super.requireRestart();
    }

    @Override
    public TextFieldBuilder setSaveConsumer(Consumer<String> saveConsumer) {
        return (TextFieldBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public TextFieldBuilder setDefaultValue(Supplier<String> defaultValue) {
        return (TextFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public TextFieldBuilder setDefaultValue(String defaultValue) {
        return (TextFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public TextFieldBuilder setTooltipSupplier(Function<String, Optional<ITextComponent[]>> tooltipSupplier) {
        return (TextFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public TextFieldBuilder setTooltipSupplier(Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        return (TextFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public TextFieldBuilder setTooltip(Optional<ITextComponent[]> tooltip) {
        return (TextFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public TextFieldBuilder setTooltip(ITextComponent ... tooltip) {
        return (TextFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    @NotNull
    public StringListEntry build() {
        StringListEntry entry = new StringListEntry(this.getFieldNameKey(), (String)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart());
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

