/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SelectorBuilder<T>
extends AbstractFieldBuilder<T, SelectionListEntry<T>, SelectorBuilder<T>> {
    private final T[] valuesArray;
    private Function<T, ITextComponent> nameProvider = null;

    public SelectorBuilder(ITextComponent resetButtonKey, ITextComponent fieldNameKey, T[] valuesArray, T value) {
        super(resetButtonKey, fieldNameKey);
        Objects.requireNonNull(value);
        this.valuesArray = valuesArray;
        this.value = value;
    }

    @Override
    public SelectorBuilder<T> setErrorSupplier(Function<T, Optional<ITextComponent>> errorSupplier) {
        return (SelectorBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public SelectorBuilder<T> requireRestart() {
        return (SelectorBuilder)super.requireRestart();
    }

    @Override
    public SelectorBuilder<T> setSaveConsumer(Consumer<T> saveConsumer) {
        return (SelectorBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public SelectorBuilder<T> setDefaultValue(Supplier<T> defaultValue) {
        return (SelectorBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public SelectorBuilder<T> setDefaultValue(T defaultValue) {
        return (SelectorBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public SelectorBuilder<T> setTooltipSupplier(Function<T, Optional<ITextComponent[]>> tooltipSupplier) {
        return (SelectorBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public SelectorBuilder<T> setTooltipSupplier(Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        return (SelectorBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public SelectorBuilder<T> setTooltip(Optional<ITextComponent[]> tooltip) {
        return (SelectorBuilder)super.setTooltip(tooltip);
    }

    @Override
    public SelectorBuilder<T> setTooltip(ITextComponent ... tooltip) {
        return (SelectorBuilder)super.setTooltip(tooltip);
    }

    public SelectorBuilder<T> setNameProvider(Function<T, ITextComponent> enumNameProvider) {
        this.nameProvider = enumNameProvider;
        return this;
    }

    @Override
    @NotNull
    public SelectionListEntry<T> build() {
        SelectionListEntry<Object> entry = new SelectionListEntry<Object>(this.getFieldNameKey(), this.valuesArray, this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), this.nameProvider, null, this.isRequireRestart());
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

