/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.LongListListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractRangeListBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class LongListBuilder
extends AbstractRangeListBuilder<Long, LongListListEntry, LongListBuilder> {
    private Function<LongListListEntry, LongListListEntry.LongListCell> createNewInstance;

    public LongListBuilder(ITextComponent resetButtonKey, ITextComponent fieldNameKey, List<Long> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    @Override
    public Function<Long, Optional<ITextComponent>> getCellErrorSupplier() {
        return super.getCellErrorSupplier();
    }

    @Override
    public LongListBuilder setCellErrorSupplier(Function<Long, Optional<ITextComponent>> cellErrorSupplier) {
        return (LongListBuilder)super.setCellErrorSupplier(cellErrorSupplier);
    }

    @Override
    public LongListBuilder setErrorSupplier(Function<List<Long>, Optional<ITextComponent>> errorSupplier) {
        return (LongListBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public LongListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        return (LongListBuilder)super.setDeleteButtonEnabled(deleteButtonEnabled);
    }

    @Override
    public LongListBuilder setInsertInFront(boolean insertInFront) {
        return (LongListBuilder)super.setInsertInFront(insertInFront);
    }

    @Override
    public LongListBuilder setAddButtonTooltip(ITextComponent addTooltip) {
        return (LongListBuilder)super.setAddButtonTooltip(addTooltip);
    }

    @Override
    public LongListBuilder setRemoveButtonTooltip(ITextComponent removeTooltip) {
        return (LongListBuilder)super.setRemoveButtonTooltip(removeTooltip);
    }

    @Override
    public LongListBuilder requireRestart() {
        return (LongListBuilder)super.requireRestart();
    }

    public LongListBuilder setCreateNewInstance(Function<LongListListEntry, LongListListEntry.LongListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    @Override
    public LongListBuilder setExpanded(boolean expanded) {
        return (LongListBuilder)super.setExpanded(expanded);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public LongListBuilder setExpended(boolean expanded) {
        return this.setExpanded(expanded);
    }

    @Override
    public LongListBuilder setSaveConsumer(Consumer<List<Long>> saveConsumer) {
        return (LongListBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public LongListBuilder setDefaultValue(Supplier<List<Long>> defaultValue) {
        return (LongListBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public LongListBuilder setMin(long min) {
        this.min = min;
        return this;
    }

    @Override
    public LongListBuilder setMax(long max) {
        this.max = max;
        return this;
    }

    @Override
    public LongListBuilder removeMin() {
        return (LongListBuilder)super.removeMin();
    }

    @Override
    public LongListBuilder removeMax() {
        return (LongListBuilder)super.removeMax();
    }

    @Override
    public LongListBuilder setDefaultValue(List<Long> defaultValue) {
        return (LongListBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public LongListBuilder setTooltipSupplier(Function<List<Long>, Optional<ITextComponent[]>> tooltipSupplier) {
        return (LongListBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public LongListBuilder setTooltipSupplier(Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        return (LongListBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public LongListBuilder setTooltip(Optional<ITextComponent[]> tooltip) {
        return (LongListBuilder)super.setTooltip(tooltip);
    }

    @Override
    public LongListBuilder setTooltip(ITextComponent ... tooltip) {
        return (LongListBuilder)super.setTooltip(tooltip);
    }

    @Override
    @NotNull
    public LongListListEntry build() {
        LongListListEntry entry = new LongListListEntry(this.getFieldNameKey(), (List)this.value, this.isExpanded(), null, this.getSaveConsumer(), this.defaultValue, this.getResetButtonKey(), this.isRequireRestart(), this.isDeleteButtonEnabled(), this.isInsertInFront());
        if (this.min != null) {
            entry.setMinimum((Long)this.min);
        }
        if (this.max != null) {
            entry.setMaximum((Long)this.max);
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setInsertButtonEnabled(this.isInsertButtonEnabled());
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        entry.setAddTooltip(this.getAddTooltip());
        entry.setRemoveTooltip(this.getRemoveTooltip());
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

