/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SelectionListEntry<T>
extends TooltipListEntry<T> {
    private final ImmutableList<T> values;
    private final AtomicInteger index;
    private final int original;
    private final Button buttonWidget;
    private final Button resetButton;
    private final Supplier<T> defaultValue;
    private final List<IGuiEventListener> widgets;
    private final Function<T, ITextComponent> nameProvider;

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(ITextComponent fieldName, T[] valuesArray, T value, ITextComponent resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(ITextComponent fieldName, T[] valuesArray, T value, ITextComponent resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, ITextComponent> nameProvider) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, nameProvider, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(ITextComponent fieldName, T[] valuesArray, T value, ITextComponent resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, ITextComponent> nameProvider, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, nameProvider, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(ITextComponent fieldName, T[] valuesArray, T value, ITextComponent resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, ITextComponent> nameProvider, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.values = valuesArray != null ? ImmutableList.copyOf((Object[])valuesArray) : ImmutableList.of(value);
        this.defaultValue = defaultValue;
        this.index = new AtomicInteger(this.values.indexOf(value));
        this.index.compareAndSet(-1, 0);
        this.original = this.values.indexOf(value);
        this.buttonWidget = new Button(0, 0, 150, 20, NarratorChatListener.field_216868_a, widget -> {
            this.index.incrementAndGet();
            this.index.compareAndSet(this.values.size(), 0);
        });
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.index.set(this.getDefaultIndex()));
        this.saveCallback = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.buttonWidget, this.resetButton});
        this.nameProvider = nameProvider == null ? t -> new TranslationTextComponent(t instanceof Translatable ? ((Translatable)t).getKey() : t.toString()) : nameProvider;
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || !Objects.equals(this.index.get(), this.original);
    }

    @Override
    public T getValue() {
        return (T)this.values.get(this.index.get());
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.field_230693_o_ = this.isEditable() && this.getDefaultValue().isPresent() && this.getDefaultIndex() != this.index.get();
        this.resetButton.field_230691_m_ = y;
        this.buttonWidget.field_230693_o_ = this.isEditable();
        this.buttonWidget.field_230691_m_ = y;
        this.buttonWidget.func_238482_a_(this.nameProvider.apply(this.getValue()));
        ITextComponent displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x;
            this.buttonWidget.field_230690_l_ = x + this.resetButton.func_230998_h_() + 2;
        } else {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x + entryWidth - this.resetButton.func_230998_h_();
            this.buttonWidget.field_230690_l_ = x + entryWidth - 150;
        }
        this.buttonWidget.func_230991_b_(150 - this.resetButton.func_230998_h_() - 2);
        this.resetButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.buttonWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private int getDefaultIndex() {
        return Math.max(0, this.values.indexOf(this.defaultValue.get()));
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }

    public static interface Translatable {
        @NotNull
        public String getKey();
    }
}

