/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.api.Modifier;
import me.shedaniel.clothconfig2.forge.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.forge.api.ScrollingContainer;
import me.shedaniel.clothconfig2.forge.gui.entries.MultiElementListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.NestedListListEntry;
import me.shedaniel.clothconfig2.forge.impl.EasingMethod;
import me.shedaniel.clothconfig2.forge.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.SubCategoryBuilder;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClothConfigInitializer {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"ClothConfig");

    @Deprecated
    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration) {
        return ScrollingContainer.handleScrollingPosition(target, scroll, maxScroll, delta, start, duration);
    }

    @Deprecated
    public static double expoEase(double start, double end, double amount) {
        return ScrollingContainer.ease(start, end, amount, ClothConfigInitializer.getEasingMethod());
    }

    @Deprecated
    public static double clamp(double v, double maxScroll) {
        return ScrollingContainer.clampExtension(v, maxScroll);
    }

    @Deprecated
    public static double clamp(double v, double maxScroll, double clampExtension) {
        return ScrollingContainer.clampExtension(v, -clampExtension, maxScroll + clampExtension);
    }

    public static EasingMethod getEasingMethod() {
        return EasingMethod.EasingMethodImpl.NONE;
    }

    public static long getScrollDuration() {
        return 0L;
    }

    public static double getScrollStep() {
        return 16.0;
    }

    public static double getBounceBackMultiplier() {
        return -10.0;
    }

    public static void registerModsPage() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> ClothConfigInitializer.getConfigBuilderWithDemo(parent).build());
    }

    public static ConfigBuilder getConfigBuilderWithDemo(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((ITextComponent)new TranslationTextComponent("title.cloth-config.config"));
        builder.setDefaultBackgroundTexture(new ResourceLocation("minecraft:textures/block/oak_planks.png"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory testing = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("category.cloth-config.testing"));
        testing.addEntry(entryBuilder.startKeyCodeField((ITextComponent)new StringTextComponent("Cool Key"), InputMappings.field_197958_a).setDefaultValue(InputMappings.field_197958_a).build());
        testing.addEntry(entryBuilder.startModifierKeyCodeField((ITextComponent)new StringTextComponent("Cool Modifier Key"), ModifierKeyCode.of(InputMappings.Type.KEYSYM.func_197944_a(79), Modifier.of(false, true, false))).setDefaultValue(ModifierKeyCode.of(InputMappings.Type.KEYSYM.func_197944_a(79), Modifier.of(false, true, false))).build());
        testing.addEntry(entryBuilder.startDoubleList((ITextComponent)new StringTextComponent("A list of Doubles"), Arrays.asList(1.0, 2.0, 3.0)).setDefaultValue(Arrays.asList(1.0, 2.0, 3.0)).build());
        testing.addEntry(entryBuilder.startLongList((ITextComponent)new StringTextComponent("A list of Longs"), Arrays.asList(1L, 2L, 3L)).setDefaultValue(Arrays.asList(1L, 2L, 3L)).build());
        testing.addEntry(entryBuilder.startStrList((ITextComponent)new StringTextComponent("A list of Strings"), Arrays.asList("abc", "xyz")).setDefaultValue(Arrays.asList("abc", "xyz")).build());
        SubCategoryBuilder colors = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Colors")).setExpanded(true);
        colors.add(entryBuilder.startColorField((ITextComponent)new StringTextComponent("A color field"), 65535).setDefaultValue(65535).build());
        colors.add(entryBuilder.startColorField((ITextComponent)new StringTextComponent("An alpha color field"), -16711681).setDefaultValue(-16711681).setAlphaMode(true).build());
        colors.add(entryBuilder.startColorField((ITextComponent)new StringTextComponent("An alpha color field"), -1).setDefaultValue(-65536).setAlphaMode(true).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        SubCategoryBuilder innerColors = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Inner Colors")).setExpanded(true);
        innerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        SubCategoryBuilder innerInnerColors = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Inner Inner Colors")).setExpanded(true);
        innerInnerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerInnerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerInnerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerColors.add(innerInnerColors.build());
        colors.add(innerColors.build());
        testing.addEntry(colors.build());
        testing.addEntry(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("Suggestion Random Int"), DropdownMenuBuilder.TopCellElementBuilder.of(10, s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        })).setDefaultValue(10).setSelections(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10})).build());
        testing.addEntry(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("Selection Random Int"), DropdownMenuBuilder.TopCellElementBuilder.of(10, s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        })).setDefaultValue(5).setSuggestionMode(false).setSelections(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10})).build());
        class Pair<T, R> {
            T t;
            R r;

            public Pair(T t, R r) {
                this.t = t;
                this.r = r;
            }

            public T getLeft() {
                return this.t;
            }

            public R getRight() {
                return this.r;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (!Objects.equals(this.t, pair.t)) {
                    return false;
                }
                return Objects.equals(this.r, pair.r);
            }

            public int hashCode() {
                int result = this.t != null ? this.t.hashCode() : 0;
                result = 31 * result + (this.r != null ? this.r.hashCode() : 0);
                return result;
            }
        }
        testing.addEntry(new NestedListListEntry<Pair, MultiElementListEntry>((ITextComponent)new StringTextComponent("Nice"), Lists.newArrayList((Object[])new Pair[]{new Pair<Integer, Integer>(10, 10), new Pair<Integer, Integer>(20, 40)}), false, Optional::empty, list -> {}, () -> Lists.newArrayList((Object[])new Pair[]{new Pair<Integer, Integer>(10, 10), new Pair<Integer, Integer>(20, 40)}), entryBuilder.getResetButtonKey(), true, true, (elem, nestedListListEntry) -> {
            if (elem == null) {
                Pair<Integer, Integer> newDefaultElemValue = new Pair<Integer, Integer>(10, 10);
                return new MultiElementListEntry<Pair<Integer, Integer>>((ITextComponent)new StringTextComponent("Pair"), newDefaultElemValue, Lists.newArrayList((Object[])new AbstractConfigListEntry[]{entryBuilder.startIntField((ITextComponent)new StringTextComponent("Left"), newDefaultElemValue.getLeft()).setDefaultValue(10).build(), entryBuilder.startIntField((ITextComponent)new StringTextComponent("Right"), newDefaultElemValue.getRight()).setDefaultValue(10).build()}), true);
            }
            return new MultiElementListEntry<Pair>((ITextComponent)new StringTextComponent("Pair"), (Pair)elem, Lists.newArrayList((Object[])new AbstractConfigListEntry[]{entryBuilder.startIntField((ITextComponent)new StringTextComponent("Left"), (Integer)elem.getLeft()).setDefaultValue(10).build(), entryBuilder.startIntField((ITextComponent)new StringTextComponent("Right"), (Integer)elem.getRight()).setDefaultValue(10).build()}), true);
        }));
        builder.transparentBackground();
        return builder;
    }
}

