/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.Requirement;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.MultiElementListEntry;
import me.shedaniel.clothconfig2.gui.entries.NestedListListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongListBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ClothConfigDemo {
    public static ConfigBuilder getConfigBuilderWithDemo() {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((ITextComponent)new TranslationTextComponent("title.cloth-config.config"));
        builder.setDefaultBackgroundTexture(new ResourceLocation("minecraft:textures/block/oak_planks.png"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory testing = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("category.cloth-config.testing"));
        testing.addEntry(entryBuilder.startKeyCodeField((ITextComponent)new StringTextComponent("Cool Key"), InputMappings.field_197958_a).setDefaultValue(InputMappings.field_197958_a).build());
        testing.addEntry(entryBuilder.startModifierKeyCodeField((ITextComponent)new StringTextComponent("Cool Modifier Key"), ModifierKeyCode.of(InputMappings.Type.KEYSYM.func_197944_a(79), Modifier.of(false, true, false))).setDefaultValue(ModifierKeyCode.of(InputMappings.Type.KEYSYM.func_197944_a(79), Modifier.of(false, true, false))).build());
        testing.addEntry(entryBuilder.startDoubleList((ITextComponent)new StringTextComponent("A list of Doubles"), Arrays.asList(1.0, 2.0, 3.0)).setDefaultValue(Arrays.asList(1.0, 2.0, 3.0)).build());
        testing.addEntry(((LongListBuilder)entryBuilder.startLongList((ITextComponent)new StringTextComponent("A list of Longs"), Arrays.asList(1L, 2L, 3L)).setDefaultValue(Arrays.asList(1L, 2L, 3L)).setInsertButtonEnabled(false)).build());
        testing.addEntry(entryBuilder.startStrList((ITextComponent)new StringTextComponent("A list of Strings"), Arrays.asList("abc", "xyz")).setTooltip(new ITextComponent[]{new StringTextComponent("Yes this is some beautiful tooltip\nOh and this is the second line!")}).setDefaultValue(Arrays.asList("abc", "xyz")).build());
        SubCategoryBuilder colors = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Colors")).setExpanded(true);
        colors.add(entryBuilder.startColorField((ITextComponent)new StringTextComponent("A color field"), 65535).setDefaultValue(65535).build());
        colors.add(entryBuilder.startColorField((ITextComponent)new StringTextComponent("An alpha color field"), -16711681).setDefaultValue(-16711681).setAlphaMode(true).build());
        colors.add(entryBuilder.startColorField((ITextComponent)new StringTextComponent("An alpha color field"), -1).setDefaultValue(-65536).setAlphaMode(true).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        colors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        SubCategoryBuilder innerColors = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Inner Colors")).setExpanded(true);
        innerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        SubCategoryBuilder innerInnerColors = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Inner Inner Colors")).setExpanded(true);
        innerInnerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerInnerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerInnerColors.add(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("lol apple"), DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(Items.field_151034_e), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(Items.field_151034_e).setSelections(Registry.field_212630_s.func_201756_e().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build());
        innerColors.add(innerInnerColors.build());
        colors.add(innerColors.build());
        testing.addEntry(colors.build());
        testing.addEntry(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("Suggestion Random Int"), DropdownMenuBuilder.TopCellElementBuilder.of(10, s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        })).setDefaultValue(10).setSelections(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10})).build());
        testing.addEntry(entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("Selection Random Int"), DropdownMenuBuilder.TopCellElementBuilder.of(10, s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        })).setDefaultValue(5).setSuggestionMode(false).setSelections(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10})).build());
        class Pair<T, R> {
            final T t;
            final R r;

            public Pair(T t, R r) {
                this.t = t;
                this.r = r;
            }

            public T getLeft() {
                return this.t;
            }

            public R getRight() {
                return this.r;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (!Objects.equals(this.t, pair.t)) {
                    return false;
                }
                return Objects.equals(this.r, pair.r);
            }

            public int hashCode() {
                int result = this.t != null ? this.t.hashCode() : 0;
                result = 31 * result + (this.r != null ? this.r.hashCode() : 0);
                return result;
            }
        }
        testing.addEntry(new NestedListListEntry<Pair, MultiElementListEntry>((ITextComponent)new StringTextComponent("Nice"), Lists.newArrayList((Object[])new Pair[]{new Pair<Integer, Integer>(10, 10), new Pair<Integer, Integer>(20, 40)}), false, Optional::empty, list -> {}, () -> Lists.newArrayList((Object[])new Pair[]{new Pair<Integer, Integer>(10, 10), new Pair<Integer, Integer>(20, 40)}), entryBuilder.getResetButtonKey(), true, true, (elem, nestedListListEntry) -> {
            if (elem == null) {
                Pair<Integer, Integer> newDefaultElemValue = new Pair<Integer, Integer>(10, 10);
                return new MultiElementListEntry<Pair<Integer, Integer>>((ITextComponent)new StringTextComponent("Pair"), newDefaultElemValue, Lists.newArrayList((Object[])new AbstractConfigListEntry[]{entryBuilder.startIntField((ITextComponent)new StringTextComponent("Left"), newDefaultElemValue.getLeft()).setDefaultValue(10).build(), entryBuilder.startIntField((ITextComponent)new StringTextComponent("Right"), newDefaultElemValue.getRight()).setDefaultValue(10).build()}), true);
            }
            return new MultiElementListEntry<Pair>((ITextComponent)new StringTextComponent("Pair"), (Pair)elem, Lists.newArrayList((Object[])new AbstractConfigListEntry[]{entryBuilder.startIntField((ITextComponent)new StringTextComponent("Left"), (Integer)elem.getLeft()).setDefaultValue(10).build(), entryBuilder.startIntField((ITextComponent)new StringTextComponent("Right"), (Integer)elem.getRight()).setDefaultValue(10).build()}), true);
        }));
        SubCategoryBuilder depends = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Dependencies")).setExpanded(true);
        BooleanListEntry dependency = entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("A cool toggle"), false).setTooltip(new ITextComponent[]{new StringTextComponent("Toggle me...")}).build();
        depends.add(dependency);
        LinkedList<BooleanListEntry> toggles = new LinkedList<BooleanListEntry>();
        toggles.add(((BooleanToggleBuilder)entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("I only work when cool is toggled..."), true).setRequirement(Requirement.isTrue(dependency))).build());
        toggles.add(((BooleanToggleBuilder)entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("I only appear when cool is toggled..."), true).setDisplayRequirement(Requirement.isTrue(dependency))).build());
        depends.addAll((Collection<? extends AbstractConfigListEntry>)toggles);
        depends.add(((BooleanToggleBuilder)entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("I only work when cool matches both of these toggles ^^"), true).setRequirement(Requirement.all((Requirement[])toggles.stream().map(toggle -> Requirement.matches(dependency, toggle)).toArray(Requirement[]::new)))).build());
        SubCategoryBuilder dependantSub = (SubCategoryBuilder)entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Sub-categories can have requirements too...")).setRequirement(Requirement.isTrue(dependency));
        dependantSub.add(entryBuilder.startTextDescription((ITextComponent)new StringTextComponent("This sub category depends on Cool being toggled")).build());
        dependantSub.add(entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("Example entry"), true).build());
        dependantSub.add(entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("Another example..."), true).build());
        depends.add(dependantSub.build());
        depends.add(((LongListBuilder)entryBuilder.startLongList((ITextComponent)new StringTextComponent("Even lists!"), Arrays.asList(1L, 2L, 3L)).setDefaultValue(Arrays.asList(1L, 2L, 3L)).setRequirement(Requirement.isTrue(dependency))).build());
        AbstractConfigListEntry enumDependency = entryBuilder.startEnumSelector((ITextComponent)new StringTextComponent("Select a good or bad option"), DependencyDemoEnum.class, DependencyDemoEnum.OKAY).build();
        depends.add(enumDependency);
        IntegerSliderEntry intDependency = entryBuilder.startIntSlider((ITextComponent)new StringTextComponent("Select something big or small"), 50, -100, 100).build();
        depends.add(intDependency);
        depends.add(((BooleanToggleBuilder)entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("I only work when a good option is chosen..."), true).setTooltip(new ITextComponent[]{new StringTextComponent("Select good or better above")}).setRequirement(Requirement.isValue(enumDependency, DependencyDemoEnum.EXCELLENT, DependencyDemoEnum.GOOD))).build());
        depends.add(((BooleanToggleBuilder)entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("I need a good option AND a cool toggle!"), true).setTooltip(new ITextComponent[]{new StringTextComponent("Select good or better and also toggle cool")}).setRequirement(Requirement.all(Requirement.isTrue(dependency), Requirement.isValue(enumDependency, DependencyDemoEnum.EXCELLENT, DependencyDemoEnum.GOOD)))).build());
        depends.add(((BooleanToggleBuilder)entryBuilder.startBooleanToggle((ITextComponent)new StringTextComponent("I only work when numbers are extreme!"), true).setTooltip(new ITextComponent[]{new StringTextComponent("Move the slider...")}).setRequirement(Requirement.any(() -> intDependency.getValue() < -70, () -> intDependency.getValue() > 70))).build());
        testing.addEntry(depends.build());
        testing.addEntry(entryBuilder.startTextDescription((ITextComponent)new TranslationTextComponent("text.cloth-config.testing.1", new Object[]{new StringTextComponent("ClothConfig").func_240700_a_(s -> s.func_240713_a_(Boolean.valueOf(true)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)new HoverEvent.ItemHover((ItemStack)Util.func_200696_a((Object)new ItemStack((IItemProvider)Items.field_221609_aK), stack -> stack.func_200302_a((ITextComponent)new StringTextComponent("(\u30fb\u2200\u30fb)")).func_77966_a(Enchantments.field_185305_q, 10)))))), new TranslationTextComponent("text.cloth-config.testing.2").func_240700_a_(s -> s.func_240712_a_(TextFormatting.BLUE).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("https://shedaniel.gitbook.io/cloth-config/"))).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://shedaniel.gitbook.io/cloth-config/"))), new TranslationTextComponent("text.cloth-config.testing.3").func_240700_a_(s -> s.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, Utils.getConfigFolder().getParent().resolve("options.txt").toString())))})).build());
        builder.transparentBackground();
        return builder;
    }

    static enum DependencyDemoEnum {
        EXCELLENT,
        GOOD,
        OKAY,
        BAD,
        HORRIBLE;

    }
}

