/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.formatter;

import com.blamejared.searchables.api.formatter.FormattingConstants;
import java.util.Objects;
import net.minecraft.util.text.Style;

public final class FormattingContext {
    private final boolean isKey;
    private final Style style;
    private final boolean valid;

    FormattingContext(boolean isKey, Style style, boolean valid) {
        this.isKey = isKey;
        this.style = style;
        this.valid = valid;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public Style style() {
        return this.style;
    }

    public boolean valid() {
        return this.valid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FormattingContext that = (FormattingContext)obj;
        return this.isKey == that.isKey && Objects.equals(this.style, that.style) && this.valid == that.valid;
    }

    public int hashCode() {
        return Objects.hash(this.isKey, this.style, this.valid);
    }

    public String toString() {
        return "FormattingContext[isKey=" + this.isKey + ", style=" + this.style + ", valid=" + this.valid + ']';
    }

    public static FormattingContext empty() {
        return new FormattingContext(false, Style.field_240709_b_, true);
    }

    public static FormattingContext key(Style validStyle, boolean valid) {
        return new FormattingContext(true, valid ? validStyle : FormattingConstants.INVALID, valid);
    }

    public static FormattingContext literal(Style validStyle, boolean valid) {
        return new FormattingContext(false, valid ? validStyle : FormattingConstants.INVALID, valid);
    }

    public Style style(boolean valid) {
        return valid ? this.style() : FormattingConstants.INVALID;
    }
}

