/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.context;

import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.context.SearchPredicate;
import java.util.Objects;
import java.util.function.Predicate;

final class SearchLiteral<T>
implements SearchPredicate<T> {
    private final String value;

    public SearchLiteral(String value) {
        this.value = value;
    }

    @Override
    public Predicate<T> predicateFrom(SearchableType<T> type) {
        return type.defaultComponent().map(SearchableComponent::filter).map(filter -> t -> filter.test(t, this.value())).orElse(t -> true);
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchLiteral that = (SearchLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "SearchLiteral{value='" + this.value + '\'' + '}';
    }
}

