/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.context;

import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.context.SearchPredicate;
import java.util.Objects;
import java.util.function.Predicate;

final class SearchComponent<T>
implements SearchPredicate<T> {
    private final String key;
    private final String value;

    public SearchComponent(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public Predicate<T> predicateFrom(SearchableType<T> type) {
        return type.component(this.key()).map(SearchableComponent::filter).map(filter -> t -> filter.test(t, this.value())).orElse(t -> true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchComponent that = (SearchComponent)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "SearchComponent{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }
}

