/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.autcomplete;

import com.blamejared.searchables.api.TokenRange;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;

public final class CompletionSuggestion {
    private final String suggestion;
    private final ITextComponent display;
    private final String suffix;
    private final TokenRange replacementRange;

    public CompletionSuggestion(String suggestion, ITextComponent display, String suffix, TokenRange replacementRange) {
        this.suggestion = suggestion;
        this.display = display;
        this.suffix = suffix;
        this.replacementRange = replacementRange;
    }

    public String suggestion() {
        return this.suggestion;
    }

    public ITextComponent display() {
        return this.display;
    }

    public String suffix() {
        return this.suffix;
    }

    public TokenRange replacementRange() {
        return this.replacementRange;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompletionSuggestion that = (CompletionSuggestion)obj;
        return Objects.equals(this.suggestion, that.suggestion) && Objects.equals(this.display, that.display) && Objects.equals(this.suffix, that.suffix) && Objects.equals(this.replacementRange, that.replacementRange);
    }

    public int hashCode() {
        return Objects.hash(this.suggestion, this.display, this.suffix, this.replacementRange);
    }

    public String toString() {
        return "CompletionSuggestion[suggestion=" + this.suggestion + ", display=" + this.display + ", suffix=" + this.suffix + ", replacementRange=" + this.replacementRange + ']';
    }

    public String replaceIn(String into) {
        return this.replacementRange.replace(into, this.toInsert());
    }

    public String toInsert() {
        return this.suggestion + this.suffix;
    }
}

