/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.autcomplete;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.autcomplete.AutoComplete;
import com.blamejared.searchables.api.autcomplete.CompletionVisitor;
import com.blamejared.searchables.api.formatter.FormattingVisitor;
import com.blamejared.searchables.mixin.AccessTextFieldWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class AutoCompletingEditBox<T>
extends TextFieldWidget {
    private final FormattingVisitor formattingVisitor;
    private final CompletionVisitor completionVisitor;
    private final DelegatingConsumers<String> responders = new DelegatingConsumers();
    private final AutoComplete<T> autoComplete;

    public AutoCompletingEditBox(FontRenderer font, int x, int y, int width, int height, ITextComponent message, SearchableType<T> type, Supplier<List<T>> entries) {
        this(font, x, y, width, height, null, message, type, entries);
    }

    public AutoCompletingEditBox(FontRenderer font, int x, int y, int width, int height, @Nullable TextFieldWidget thisBox, ITextComponent message, SearchableType<T> type, Supplier<List<T>> entries) {
        super(font, x, y, width, height, thisBox, message);
        this.func_146203_f(Integer.MAX_VALUE);
        this.formattingVisitor = new FormattingVisitor(type);
        this.completionVisitor = new CompletionVisitor();
        Objects.requireNonNull(font);
        this.autoComplete = new AutoComplete<T>(type, this, entries, x, y + 2 + height, width, 9 + 2);
        this.func_195607_a(this.formattingVisitor);
        this.func_212954_a(this.responders);
        this.addResponder(this.formattingVisitor);
        this.addResponder(this.completionVisitor);
        this.addResponder(this.autoComplete);
    }

    public boolean func_231044_a_(double xpos, double ypos, int button) {
        if (this.func_230999_j_() && this.autoComplete.func_231044_a_(xpos, ypos, button)) {
            return true;
        }
        if ((this.func_231047_b_(xpos, ypos) || this.autoComplete().func_231047_b_(xpos, ypos)) && button == 1) {
            this.func_146180_a("");
            return true;
        }
        return super.func_231044_a_(xpos, ypos, button);
    }

    public boolean func_231046_a_(int key, int scancode, int mods) {
        switch (key) {
            case 267: {
                this.autoComplete.scrollDown(this.autoComplete().maxSuggestions());
                return true;
            }
            case 264: {
                this.autoComplete().scrollDown();
                return true;
            }
            case 266: {
                this.autoComplete.scrollUp(this.autoComplete().maxSuggestions());
                return true;
            }
            case 265: {
                this.autoComplete().scrollUp();
                return true;
            }
            case 257: {
                this.autoComplete().insertSuggestion();
                return true;
            }
        }
        return super.func_231046_a_(key, scancode, mods);
    }

    public void deleteChars(TokenRange range) {
        if (!this.func_146179_b().isEmpty() && !range.isEmpty()) {
            String newValue = range.delete(this.func_146179_b());
            if (this.getFilter().test(newValue)) {
                this.func_146180_a(newValue);
                this.func_146190_e(range.start());
            }
        }
    }

    public Predicate<String> getFilter() {
        return ((AccessTextFieldWidget)((Object)this)).searchables$getFilter();
    }

    @Nullable
    public Consumer<String> getResponder() {
        return ((AccessTextFieldWidget)((Object)this)).searchables$getResponder();
    }

    @Deprecated
    public void func_212954_a(Consumer<String> responder) {
        if (this.getResponder() == null) {
            super.func_212954_a(this.responders);
        } else {
            this.addResponder(responder);
        }
    }

    public void addResponder(Consumer<String> responder) {
        this.responders.addConsumer(responder);
    }

    public FormattingVisitor formattingVisitor() {
        return this.formattingVisitor;
    }

    public CompletionVisitor completionVisitor() {
        return this.completionVisitor;
    }

    public AutoComplete<T> autoComplete() {
        return this.autoComplete;
    }

    private static class DelegatingConsumers<T>
    implements Consumer<T> {
        private final List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();

        private DelegatingConsumers() {
        }

        @Override
        public void accept(T t) {
            this.consumers.forEach(tConsumer -> tConsumer.accept(t));
        }

        public void addConsumer(Consumer<T> consumer) {
            this.consumers.add(consumer);
        }
    }
}

