/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.autcomplete;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.blamejared.searchables.api.autcomplete.CompletionSuggestion;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class AutoComplete<T>
extends Widget
implements Consumer<String> {
    private final SearchableType<T> type;
    private final AutoCompletingEditBox<T> editBox;
    private final Supplier<List<T>> entries;
    private final int suggestionHeight;
    private final int maxSuggestions;
    private List<CompletionSuggestion> suggestions;
    private int displayOffset;
    private int selectedIndex;
    private final Vector2d lastMousePosition;
    private int lastCursorPosition;

    public AutoComplete(SearchableType<T> type, AutoCompletingEditBox<T> editBox, Supplier<List<T>> entries, int x, int y, int width, int suggestionHeight) {
        this(type, editBox, entries, x, y, width, suggestionHeight, 7);
    }

    public AutoComplete(SearchableType<T> type, AutoCompletingEditBox<T> editBox, Supplier<List<T>> entries, int x, int y, int width, int suggestionHeight, int maxSuggestions) {
        super(x, y, width, suggestionHeight * maxSuggestions, (ITextComponent)new StringTextComponent(""));
        this.type = type;
        this.editBox = editBox;
        this.entries = entries;
        this.suggestionHeight = suggestionHeight;
        this.maxSuggestions = maxSuggestions;
        this.suggestions = Collections.emptyList();
        this.displayOffset = 0;
        this.selectedIndex = -1;
        this.lastMousePosition = new Vector2d(0.0, 0.0);
        this.lastCursorPosition = -1;
    }

    @Override
    public void accept(String value) {
        int position = this.editBox().func_146198_h();
        if (this.lastCursorPosition != position) {
            this.displayOffset = 0;
            this.selectedIndex = 0;
            TokenRange replacementRange = this.editBox().completionVisitor().rangeAt(position);
            this.suggestions = this.type.getSuggestionsFor(this.entries.get(), value, position, replacementRange);
        }
        this.lastCursorPosition = position;
    }

    protected boolean func_230992_c_(double xpos, double ypos) {
        return super.func_230992_c_(xpos, ypos) && ypos < (double)(this.getY() + this.suggestionHeight * this.shownSuggestions());
    }

    public boolean func_231047_b_(double xpos, double ypos) {
        return super.func_231047_b_(xpos, ypos) && ypos < (double)(this.getY() + this.suggestionHeight * this.shownSuggestions());
    }

    public boolean func_231043_a_(double xpos, double ypos, double delta) {
        if (this.func_231047_b_(xpos, ypos) || this.editBox().func_231047_b_(xpos, ypos)) {
            this.displayOffset = (int)MathHelper.func_151237_a((double)((double)this.displayOffset - delta), (double)0.0, (double)Math.max(this.suggestions.size() - this.maxSuggestions, 0));
            this.lastMousePosition.set(0.0);
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double mx, double my, int mb) {
        if (super.func_231044_a_(mx, my, mb)) {
            this.updateHoveringState(mx, my);
            if (this.selectedIndex != -1) {
                this.insertSuggestion();
            }
            return true;
        }
        return false;
    }

    public void insertSuggestion() {
        int index = this.displayOffset + this.selectedIndex;
        if (index >= 0 && index < this.suggestions.size()) {
            CompletionSuggestion suggestion = this.suggestions.get(index);
            this.editBox.deleteChars(suggestion.replacementRange());
            this.editBox.func_146191_b(suggestion.toInsert());
        }
    }

    public void func_230431_b_(MatrixStack pose, int mx, int my, float partial) {
        if (!this.editBox.func_230999_j_()) {
            return;
        }
        this.updateHoveringState(mx, my);
        for (int i = this.displayOffset; i < Math.min(this.displayOffset + this.maxSuggestions, this.suggestions.size()); ++i) {
            CompletionSuggestion suggestion = this.suggestions.get(i);
            int minX = this.getX() + 2;
            int minY = this.getY() + this.suggestionHeight * (i - this.displayOffset);
            int maxY = minY + this.suggestionHeight;
            boolean hovered = this.selectedIndex != -1 && this.displayOffset + this.selectedIndex == i;
            AutoComplete.func_238467_a_((MatrixStack)pose, (int)this.getX(), (int)minY, (int)(this.getX() + this.func_230998_h_()), (int)maxY, (int)(hovered ? -535752431 : -536870912));
            Minecraft.func_71410_x().field_71466_p.func_243246_a(pose, suggestion.display(), (float)minX, (float)(minY + 1), hovered ? Objects.requireNonNull(TextFormatting.YELLOW.func_211163_e()) : -1);
        }
        this.lastMousePosition.set(mx, my);
    }

    private void updateHoveringState(double xpos, double ypos) {
        if (!this.lastMousePosition.equals(xpos, ypos)) {
            this.selectedIndex = -1;
            if (this.func_231047_b_(xpos, ypos)) {
                int minY = this.getY();
                for (int i = 0; i < this.shownSuggestions(); ++i) {
                    int maxY = minY + this.suggestionHeight;
                    if (xpos >= (double)this.getX() && xpos <= (double)(this.getX() + this.func_230998_h_()) && ypos >= (double)minY && ypos < (double)maxY) {
                        this.selectedIndex = i;
                    }
                    minY = maxY;
                }
            }
        }
    }

    public void scrollUp() {
        this.scrollUp(1);
    }

    public void scrollUp(int amount) {
        this.offsetDisplay(this.selectedIndex - amount);
    }

    public void scrollDown() {
        this.scrollDown(1);
    }

    public void scrollDown(int amount) {
        this.offsetDisplay(this.selectedIndex + amount);
    }

    private void offsetDisplay(int offset) {
        int halfSuggestions;
        int currentItem = this.displayOffset + (offset = MathHelper.func_76125_a((int)offset, (int)0, (int)(this.shownSuggestions() - 1)));
        if (currentItem < this.displayOffset + (halfSuggestions = Math.floorDiv(this.maxSuggestions, 2))) {
            this.displayOffset = Math.max(currentItem - halfSuggestions, 0);
        } else if (currentItem > this.displayOffset + halfSuggestions) {
            this.displayOffset = Math.min(currentItem - halfSuggestions, Math.max(this.suggestions.size() - this.maxSuggestions, 0));
        }
        this.selectedIndex = currentItem - this.displayOffset;
    }

    private int shownSuggestions() {
        return Math.min(this.maxSuggestions, this.suggestions.size());
    }

    public int maxSuggestions() {
        return this.maxSuggestions;
    }

    public AutoCompletingEditBox<T> editBox() {
        return this.editBox;
    }

    protected int getX() {
        return this.field_230690_l_;
    }

    protected int getY() {
        return this.field_230691_m_;
    }

    private static class Vector2d {
        public double x;
        public double y;

        public Vector2d(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void set(double val) {
            this.x = val;
            this.y = val;
        }

        public void set(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(double x, double y) {
            return Double.doubleToLongBits(this.x) != Double.doubleToLongBits(x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(y);
        }
    }
}

