/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.tileentity.SharestoneTileEntity;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SharestoneBlock
extends WaystoneBlockBase {
    private static final VoxelShape LOWER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)SharestoneBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{SharestoneBlock.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), SharestoneBlock.func_208617_a((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), SharestoneBlock.func_208617_a((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)}).func_197753_c();
    private static final VoxelShape UPPER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)SharestoneBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape[])new VoxelShape[]{SharestoneBlock.func_208617_a((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), SharestoneBlock.func_208617_a((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), SharestoneBlock.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
    @Nullable
    private final DyeColor color;

    public SharestoneBlock(@Nullable DyeColor color) {
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SharestoneTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Override
    protected void handleActivation(World world, BlockPos pos, PlayerEntity player, WaystoneTileEntityBase tileEntity, IWaystone waystone) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSelectionContainerProvider(), it -> WaystoneSelectionContainer.writeSharestoneContainer(it, pos, this.color));
        }
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent component = new TranslationTextComponent(this.color != null ? "tooltip.waystones." + this.color.func_176762_d() + "_sharestone" : "tooltip.waystones.sharestone");
        component.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)component);
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HALF});
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }
}

