/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.client.config.TopLevelCategory;
import vazkii.quark.base.client.config.external.ExternalConfigHandler;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.IConfigCallback;

@OnlyIn(value=Dist.CLIENT)
public final class IngameConfigHandler
implements IConfigCallback {
    public static final IngameConfigHandler INSTANCE = new IngameConfigHandler();
    public Map<String, TopLevelCategory> topLevelCategories = new LinkedHashMap<String, TopLevelCategory>();
    private IConfigCategory currCategory = null;

    private IngameConfigHandler() {
    }

    @Override
    public void push(String s, String comment, Object holderObject) {
        IConfigCategory newCategory = null;
        if (this.currCategory == null) {
            newCategory = new TopLevelCategory(s, comment, null);
            this.topLevelCategories.put(s, (TopLevelCategory)newCategory);
        } else {
            newCategory = this.currCategory.addCategory(s, comment, holderObject);
        }
        this.currCategory = newCategory;
    }

    @Override
    public void pop() {
        if (this.currCategory != null) {
            this.currCategory.close();
            this.currCategory = this.currCategory.getParent();
        }
    }

    @Override
    public <T> void addEntry(ForgeConfigSpec.ConfigValue<T> value, T default_, Supplier<T> getter, String comment, Predicate<Object> restriction) {
        if (this.currCategory != null) {
            this.currCategory.addEntry(value, default_, getter, comment, restriction);
        }
    }

    public IConfigObject<Boolean> getCategoryEnabledObject(ModuleCategory category) {
        return this.topLevelCategories.get("categories").getModuleOption(category);
    }

    public IConfigCategory getConfigCategory(ModuleCategory category) {
        return this.topLevelCategories.get(category == null ? "general" : category.name);
    }

    public void refresh() {
        this.topLevelCategories.values().forEach(IConfigElement::refresh);
    }

    public void commit() {
        IngameConfigHandler.commit(this.topLevelCategories);
        ExternalConfigHandler.instance.commit();
    }

    public static <T extends IConfigCategory> void commit(Map<String, T> map) {
        for (IConfigCategory c : map.values()) {
            if (!c.isDirty()) continue;
            c.save();
            c.clean();
        }
    }
}

