/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.scripting.CarryOnOverride;

public class CarryRenderHelper {
    public static Vector3d getExactPos(Entity entity, float partialticks) {
        return new Vector3d(entity.field_70142_S + (entity.func_226277_ct_() - entity.field_70142_S) * (double)partialticks, entity.field_70137_T + (entity.func_226278_cu_() - entity.field_70137_T) * (double)partialticks, entity.field_70136_U + (entity.func_226281_cx_() - entity.field_70136_U) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(LivingEntity entity, float partialticks) {
        if (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof LivingEntity) {
            return -(entity.field_70758_at + (entity.field_70759_as - entity.field_70758_at) * partialticks);
        }
        return -(entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialticks);
    }

    public static Quaternion getExactBodyRotation(LivingEntity entity, float partialticks) {
        return Vector3f.field_229181_d_.func_229187_a_(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void performOverrideTransformation(MatrixStack matrix, CarryOnOverride override) {
        int perspective = CarryRenderHelper.getPerspective();
        float[] translation = ScriptParseHelper.getXYZArray(override.getRenderTranslation());
        float[] rotation = ScriptParseHelper.getXYZArray(override.getRenderRotation());
        float[] scaled = ScriptParseHelper.getScaled(override.getRenderScaled());
        Quaternion rot = Vector3f.field_229179_b_.func_229187_a_(rotation[0]);
        rot.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(rotation[1]));
        rot.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(rotation[2]));
        matrix.func_227863_a_(rot);
        matrix.func_227861_a_((double)translation[0], (double)translation[1], perspective == 1 && override.isBlock() ? (double)(-translation[2]) : (double)translation[2]);
        matrix.func_227862_a_(scaled[0], scaled[1], scaled[2]);
    }

    public static void renderItem(BlockState state, CompoundNBT tag, ItemStack stack, ItemStack tileStack, MatrixStack matrix, IRenderTypeBuffer buffer, int light, IBakedModel model) {
        Object override;
        if (ModelOverridesHandler.hasCustomOverrideModel(state, tag) && (override = ModelOverridesHandler.getOverrideObject(state, tag)) instanceof ItemStack) {
            Minecraft.func_71410_x().func_175599_af().func_229111_a_((ItemStack)override, ItemCameraTransforms.TransformType.NONE, false, matrix, buffer, light, 0xFFFFFF, model);
            return;
        }
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(tileStack.func_190926_b() ? stack : tileStack, ItemCameraTransforms.TransformType.NONE, false, matrix, buffer, light, 0xFFFFFF, model);
    }

    public static int getPerspective() {
        boolean isThirdPerson = !Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a();
        boolean isThirdPersonReverse = Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243193_b();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }
}

