/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.render.FluidRenderMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class UtilFluid {
    public static final FluidRenderMap<Int2ObjectMap<Model3D>> CACHED_FLUIDS = new FluidRenderMap();
    public static final int STAGES = 1400;

    public static TextureAtlasSprite getBaseFluidTexture(Fluid fluid, FluidRenderMap.FluidType type) {
        FluidAttributes fluidAttributes = fluid.getAttributes();
        ResourceLocation spriteLocation = type == FluidRenderMap.FluidType.STILL ? fluidAttributes.getStillTexture() : fluidAttributes.getFlowingTexture();
        return UtilFluid.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(spriteLocation);
    }

    public static Model3D getFluidModel(FluidStack fluid, int stage) {
        Int2ObjectMap fluidCache = (Int2ObjectMap)CACHED_FLUIDS.computeIfAbsent(fluid, fluidStack -> new Int2ObjectOpenHashMap());
        Model3D model = (Model3D)fluidCache.get(stage);
        if (model != null) {
            return model;
        }
        model = new Model3D();
        model.setTexture(FluidRenderMap.getFluidTexture(fluid, FluidRenderMap.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            double sideSpacing = 0.00625;
            double belowSpacing = 0.015625;
            model.minX = sideSpacing;
            model.minY = belowSpacing;
            model.minZ = sideSpacing;
            model.maxX = 1.0 - sideSpacing;
            model.maxY = 1.0 - belowSpacing;
            model.maxZ = 1.0 - sideSpacing;
        }
        fluidCache.put(stage, (Object)model);
        return model;
    }

    public static boolean insertSourceCauldron(World level, BlockPos posTarget, IFluidHandler tank) {
        FluidStack simulate;
        BlockState targetState = level.func_180495_p(posTarget);
        if (targetState.func_177230_c() == Blocks.field_150383_bp.getBlock() && targetState.func_235901_b_((Property)CauldronBlock.field_176591_a) && (Integer)targetState.func_177229_b((Property)CauldronBlock.field_176591_a) == 0 && (simulate = tank.drain(new FluidStack(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 1000), IFluidHandler.FluidAction.SIMULATE)).getAmount() == 1000 && level.func_175656_a(posTarget, (BlockState)targetState.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(3)))) {
            tank.drain(new FluidStack(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 1000), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static void extractSourceWaterloggedCauldron(World level, BlockPos posTarget, IFluidHandler tank) {
        int simFill;
        if (tank == null) {
            return;
        }
        BlockState targetState = level.func_180495_p(posTarget);
        FluidState fluidState = level.func_204610_c(posTarget);
        if (targetState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)targetState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            int simFill2 = tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (simFill2 == 1000 && level.func_175656_a(posTarget, (BlockState)targetState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)))) {
                tank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (targetState.func_177230_c() == Blocks.field_150383_bp && (Integer)targetState.func_177229_b((Property)CauldronBlock.field_176591_a) >= 3) {
            int simFill3 = tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (simFill3 == 1000 && level.func_175656_a(posTarget, Blocks.field_150383_bp.func_176223_P())) {
                tank.fill(new FluidStack(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        } else if (fluidState != null && fluidState.func_206889_d() && fluidState.func_206886_c() != null && (simFill = tank.fill(new FluidStack(new FluidStack(fluidState.func_206886_c(), 1000), 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000 && level.func_175656_a(posTarget, Blocks.field_150350_a.func_176223_P())) {
            tank.fill(new FluidStack(fluidState.func_206886_c(), 1000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static float getScale(FluidTank tank) {
        return UtilFluid.getScale(tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(int stored, int capacity, boolean empty) {
        return (float)stored / (float)capacity;
    }

    public static IFluidHandler getTank(World world, BlockPos pos, Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
    }

    public static boolean tryFillPositionFromTank(World world, BlockPos posSide, Direction sideOpp, IFluidHandler tankFrom, int amount) {
        IFluidHandler fluidTo;
        if (amount <= 0) {
            return false;
        }
        if (tankFrom == null) {
            return false;
        }
        LazyOptional testNull = FluidUtil.getFluidHandler((World)world, (BlockPos)posSide, (Direction)sideOpp);
        IFluidHandler iFluidHandler = fluidTo = testNull == null ? null : (IFluidHandler)testNull.orElse(null);
        if (fluidTo == null) {
            return false;
        }
        FluidStack toBeDrained = tankFrom.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        if (toBeDrained.isEmpty()) {
            return false;
        }
        int filledAmount = fluidTo.fill(toBeDrained, IFluidHandler.FluidAction.EXECUTE);
        if (filledAmount <= 0) {
            return false;
        }
        FluidStack drained = tankFrom.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE);
        int drainedAmount = drained.getAmount();
        if (filledAmount != drainedAmount) {
            ModCyclic.LOGGER.error("Imbalance filling fluids, filled " + filledAmount + " drained " + drainedAmount);
        }
        return true;
    }
}

