/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GrowthUtil {
    public static boolean isValidGrow(World world, BlockPos current) {
        if (world.func_175623_d(current)) {
            return false;
        }
        BlockState bState = world.func_180495_p(current);
        if (!bState.func_235714_a_((ITag)BlockTags.field_226152_ab_) && !bState.func_235714_a_((ITag)BlockTags.field_200030_g)) {
            ModCyclic.LOGGER.info("terra-grow can only grow minecraft:crops | minecraft:saplings : " + bState.func_177230_c());
            return false;
        }
        if (bState.func_177230_c() instanceof IGrowable) {
            IGrowable crop = (IGrowable)bState.func_177230_c();
            if (!crop.func_176473_a((IBlockReader)world, current, bState, world.field_72995_K)) {
                ModCyclic.LOGGER.info("terra-grow crop cannot grow right now " + bState.func_177230_c());
                return false;
            }
            if (!crop.func_180670_a(world, world.field_73012_v, current, bState)) {
                ModCyclic.LOGGER.info("terra-grow canUseBonemeal is false  " + bState.func_177230_c());
                return false;
            }
        }
        return true;
    }

    public static boolean tryGrow(World world, BlockPos current, double d) {
        if (!GrowthUtil.isValidGrow(world, current)) {
            return false;
        }
        if (d >= 1.0 || world.field_73012_v.nextDouble() < d) {
            BlockState bState = world.func_180495_p(current);
            Block block = bState.func_177230_c();
            if (world instanceof ServerWorld) {
                try {
                    GrowthUtil.grow(world, current, bState, block);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    private static void grow(World world, BlockPos current, BlockState bState, Block block) {
        ServerWorld sw = (ServerWorld)world;
        if (bState.func_177230_c() instanceof IGrowable) {
            IGrowable crop = (IGrowable)bState.func_177230_c();
            crop.func_225535_a_(sw, world.field_73012_v, current, bState);
        } else {
            block.func_225542_b_(bState, sw, current, world.field_73012_v);
            block.func_225542_b_(bState, sw, current, world.field_73012_v);
            block.func_225542_b_(bState, sw, current, world.field_73012_v);
        }
        ModCyclic.LOGGER.info("terra-grow Successful growth" + block);
    }
}

