/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.render;

import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderResizableCuboid {
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;
    protected EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();

    private static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
        if (axis == Direction.Axis.X) {
            return new Vector3f(value, vector.func_195900_b(), vector.func_195902_c());
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(vector.func_195899_a(), value, vector.func_195902_c());
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(vector.func_195899_a(), vector.func_195900_b(), value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public static double getValue(Vector3d vector, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return vector.field_72450_a;
        }
        if (axis == Direction.Axis.Y) {
            return vector.field_72448_b;
        }
        if (axis == Direction.Axis.Z) {
            return vector.field_72449_c;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public void renderCube(Model3D cube, MatrixStack matrix, IVertexBuilder buffer, int argb, int light) {
        float red = UtilRender.getRed(argb);
        float green = UtilRender.getGreen(argb);
        float blue = UtilRender.getBlue(argb);
        float alpha = UtilRender.getAlpha(argb);
        Vector3d size = new Vector3d(cube.sizeX(), cube.sizeY(), cube.sizeZ());
        matrix.func_227860_a_();
        matrix.func_227861_a_(cube.minX, cube.minY, cube.minZ);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        for (Direction face : Direction.values()) {
            int ordinal;
            TextureAtlasSprite sprite;
            if (!cube.shouldSideRender(face) || (sprite = cube.textures[ordinal = face.ordinal()]) == null) continue;
            Direction.Axis u = face.func_176740_k() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction.Axis v = face.func_176740_k() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
            float other = face.func_176743_c() == Direction.AxisDirection.POSITIVE ? (float)RenderResizableCuboid.getValue(size, face.func_176740_k()) : 0.0f;
            face = face.func_176743_c() == Direction.AxisDirection.NEGATIVE ? face : face.func_176734_d();
            Direction opposite = face.func_176734_d();
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94210_h();
            float maxV = sprite.func_94206_g();
            double sizeU = RenderResizableCuboid.getValue(size, u);
            double sizeV = RenderResizableCuboid.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    addU = sizeU - (double)uIndex;
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        addV = sizeV - (double)vIndex;
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.func_227865_b_();
    }

    private void renderPoint(Matrix4f matrix4f, IVertexBuilder buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light) {
        int uFinal = minU ? 0 : 1;
        int vFinal = minV ? 2 : 3;
        Vector3f vertex = RenderResizableCuboid.withValue(VEC_ZERO, u, xyz[uFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, v, xyz[vFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, face.func_176740_k(), other);
        buffer.func_227888_a_(matrix4f, vertex.func_195899_a(), vertex.func_195900_b(), vertex.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_225583_a_(uv[uFinal], uv[vFinal]).func_227886_a_(light).func_181675_d();
    }
}

