/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.registry;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.block.conveyor.ConveyorItemRenderer;
import com.lothrazar.cyclic.block.facade.RenderCableFacade;
import com.lothrazar.cyclic.event.ClientInputEvents;
import com.lothrazar.cyclic.event.EventRender;
import com.lothrazar.cyclic.item.storagebag.ItemStorageBag;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntityType;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistryCyclic {
    public static KeyBinding CAKE;

    public ClientRegistryCyclic() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientInputEvents());
        MinecraftForge.EVENT_BUS.register((Object)new EventRender());
    }

    public static void setupClient(FMLClientSetupEvent event) {
        for (BlockBase b : BlockRegistry.blocksClientRegistry) {
            b.registerClient();
        }
        for (ItemBase i : ItemRegistry.items) {
            i.registerClient();
        }
        ClientRegistryCyclic.initColours();
        ClientRegistryCyclic.initKeybindings();
        ClientRegistry.bindTileEntityRenderer(TileRegistry.energy_pipeTile, RenderCableFacade::new);
        ClientRegistry.bindTileEntityRenderer(TileRegistry.fluid_pipeTile, RenderCableFacade::new);
        ClientRegistry.bindTileEntityRenderer(TileRegistry.item_pipeTile, RenderCableFacade::new);
    }

    private static void initKeybindings() {
        CAKE = new KeyBinding("key.cyclic.cake", new IKeyConflictContext(){

            public boolean isActive() {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                ModCyclic.LOGGER.info("only active when this is null? " + player.field_71070_bA);
                return true;
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other || KeyConflictContext.IN_GAME == other;
            }
        }, InputMappings.Type.KEYSYM.func_197944_a(88), "key.cyclic.category");
        ClientRegistry.registerKeyBinding((KeyBinding)CAKE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void initColours() {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (stack.func_77973_b() == ItemRegistry.storage_bag) {
                if (tintIndex == 0) {
                    return -1;
                }
                int c = ItemStorageBag.getColour(stack);
                return c;
            }
            if (stack.func_77973_b() == ItemRegistry.mob_container && stack.func_77942_o() && tintIndex > 0) {
                EntityType thing = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("cyclic:magicnet_id")));
                for (SpawnEggItem spawneggitem : SpawnEggItem.func_195985_g()) {
                    if (spawneggitem.func_208076_b(null) != thing) continue;
                    return spawneggitem.func_195983_a(tintIndex - 1);
                }
            }
            return -1;
        }, new IItemProvider[]{ItemRegistry.mob_container, ItemRegistry.storage_bag});
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerModels(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.snowbolt, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.lightningbolt, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.boomerang_stun, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.boomerang_carry, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.boomerang_damage, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.NETBALL, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.torchbolt, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.DUNGEON, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.eye, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.fire_bolt, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.conveyor_item, render -> new ConveyorItemRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRegistry.stone_bolt, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
    }
}

