/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.recipe;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.recipe.FluidTagIngredient;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CyclicRecipe
implements IRecipe<TileEntityBase> {
    private final ResourceLocation id;

    protected CyclicRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack getCraftingResult(TileEntityBase inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public FluidStack getRecipeFluid() {
        return FluidStack.EMPTY;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }

    public static boolean matchFluid(FluidStack tileFluid, FluidTagIngredient ing) {
        if (tileFluid == null || tileFluid.isEmpty()) {
            return false;
        }
        if (ing.hasFluid() && tileFluid.getFluid() == ing.getFluidStack().getFluid()) {
            return true;
        }
        if (ing.hasTag()) {
            for (ITag.INamedTag fluidTag : FluidTags.func_241280_c_()) {
                if (!ing.getTag().equalsIgnoreCase(fluidTag.func_230234_a_().toString())) continue;
                return tileFluid.getFluid().func_207185_a((ITag)fluidTag);
            }
        }
        return false;
    }

    public static FluidTagIngredient parseFluid(JsonObject json, String key) {
        JsonObject mix = json.get(key).getAsJsonObject();
        int count = mix.get("count").getAsInt();
        if (count < 1) {
            count = 1;
        }
        FluidStack fluidstack = FluidStack.EMPTY;
        if (mix.has("fluid")) {
            String fluidId = JSONUtils.func_151200_h((JsonObject)mix, (String)"fluid");
            ResourceLocation resourceLocation = new ResourceLocation(fluidId);
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
            fluidstack = fluid == null ? FluidStack.EMPTY : new FluidStack(fluid, count);
        }
        String ftag = mix.has("tag") ? mix.get("tag").getAsString() : "";
        return new FluidTagIngredient(fluidstack, ftag, count);
    }
}

