/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainerProvider;
import com.lothrazar.cyclic.item.craftingsimple.CraftingStickContainer;
import com.lothrazar.cyclic.item.craftingsimple.CraftingStickContainerProvider;
import com.lothrazar.cyclic.item.storagebag.ContainerStorageBag;
import com.lothrazar.cyclic.item.storagebag.StorageBagContainerProvider;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketItemGui
extends PacketBase {
    private int slot;
    private Item item;

    public PacketItemGui(int slot, Item item) {
        this.slot = slot;
        this.item = item;
    }

    public static void handle(PacketItemGui message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (message.item == ItemRegistry.storage_bag && !(player.field_71070_bA instanceof ContainerStorageBag)) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new StorageBagContainerProvider(), (BlockPos)player.func_233580_cy_());
            } else if (message.item == ItemRegistry.crafting_bag && !(player.field_71070_bA instanceof CraftingBagContainer)) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new CraftingBagContainerProvider(message.slot), buf -> buf.writeInt(message.slot));
            } else if (message.item == ItemRegistry.crafting_stick && !(player.field_71070_bA instanceof CraftingStickContainer)) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new CraftingStickContainerProvider(), (BlockPos)player.func_233580_cy_());
            }
        });
        message.done(ctx);
    }

    public static PacketItemGui decode(PacketBuffer buf) {
        PacketItemGui p = new PacketItemGui(buf.readInt(), buf.func_150791_c().func_77973_b());
        return p;
    }

    public static void encode(PacketItemGui msg, PacketBuffer buf) {
        buf.writeInt(msg.slot);
        buf.func_150788_a(new ItemStack((IItemProvider)msg.item));
    }
}

