/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.transporter;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class TileTransporterItem
extends ItemBase {
    public static final String KEY_BLOCKID = "block";
    public static final String KEY_BLOCKTILE = "tile";
    public static final String KEY_BLOCKNAME = "blockname";
    public static final String KEY_BLOCKSTATE = "blockstate";

    public TileTransporterItem(Item.Properties prop) {
        super(prop);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos offset;
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        World world = context.func_195991_k();
        if (!world.func_175623_d(offset = pos.func_177972_a(side))) {
            return ActionResultType.FAIL;
        }
        if (this.placeStoredTileEntity(player, stack, offset)) {
            player.func_184611_a(context.func_221531_n(), ItemStack.field_190927_a);
            UtilSound.playSound((Entity)player, SoundRegistry.THUNK);
            if (!player.func_184812_l_()) {
                UtilItemStack.dropItemStackMotionless(world, player.func_233580_cy_(), new ItemStack((IItemProvider)ItemRegistry.tile_transporterempty));
            }
        }
        return ActionResultType.SUCCESS;
    }

    private boolean placeStoredTileEntity(PlayerEntity player, ItemStack heldChestSack, BlockPos pos) {
        CompoundNBT itemData = heldChestSack.func_196082_o();
        ResourceLocation res = new ResourceLocation(itemData.func_74779_i(KEY_BLOCKID));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(res);
        if (block == null) {
            heldChestSack = ItemStack.field_190927_a;
            UtilChat.addChatMessage(player, "Invalid block id " + res);
            return false;
        }
        BlockState toPlace = NBTUtil.func_190008_d((CompoundNBT)itemData.func_74775_l(KEY_BLOCKSTATE));
        if (((Boolean)ConfigRegistry.OVERRIDE_TRANSPORTER_SINGLETON.get()).booleanValue() && toPlace.func_235901_b_((Property)BlockStateProperties.field_208140_ao) && toPlace.func_177229_b((Property)BlockStateProperties.field_208140_ao) != ChestType.SINGLE) {
            toPlace = (BlockState)toPlace.func_206870_a((Property)BlockStateProperties.field_208140_ao, (Comparable)ChestType.SINGLE);
        }
        World world = player.func_130014_f_();
        try {
            world.func_175656_a(pos, toPlace);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                CompoundNBT tileData = itemData.func_74775_l(KEY_BLOCKTILE);
                tileData.func_74768_a("x", pos.func_177958_n());
                tileData.func_74768_a("y", pos.func_177956_o());
                tileData.func_74768_a("z", pos.func_177952_p());
                tile.func_230337_a_(toPlace, tileData);
                tile.func_70296_d();
                world.func_175646_b(pos, tile);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error attempting to place block in world", e);
            UtilChat.sendStatusMessage(player, "chest_sack.error.place");
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return false;
        }
        heldChestSack = ItemStack.field_190927_a;
        heldChestSack.func_77982_d(null);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(KEY_BLOCKNAME)) {
            String blockname = itemStack.func_77978_p().func_74779_i(KEY_BLOCKNAME);
            if (blockname != null && blockname.length() > 0) {
                TranslationTextComponent t = new TranslationTextComponent(UtilChat.lang(blockname));
                t.func_240699_a_(TextFormatting.DARK_GREEN);
                list.add((ITextComponent)t);
            }
        } else {
            TranslationTextComponent t = new TranslationTextComponent(UtilChat.lang("invalid"));
            t.func_240699_a_(TextFormatting.DARK_RED);
            list.add((ITextComponent)t);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

