/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.findspawner;

import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDungeonEye
extends ProjectileItemEntity {
    private static final double DISTLIMIT = 0.8;
    private static final double VERT = (double)0.015f;
    private static final double HORIZ = 0.0025;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean isLost = true;

    public EntityDungeonEye(EntityType<? extends ProjectileItemEntity> entityType, World world) {
        super(entityType, world);
    }

    public EntityDungeonEye(LivingEntity livingEntityIn, World worldIn) {
        super(EntityRegistry.DUNGEON, livingEntityIn, worldIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74780_a("sp_target_x", this.targetX);
        compound.func_74780_a("sp_target_y", this.targetY);
        compound.func_74780_a("sp_target_z", this.targetZ);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74757_a("isLost", this.isLost);
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.targetX = compound.func_74769_h("sp_target_x");
        this.targetY = compound.func_74769_h("sp_target_y");
        this.targetZ = compound.func_74769_h("sp_target_z");
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.isLost = compound.func_74767_n("isLost");
    }

    public void moveTowards(BlockPos pos) {
        this.targetX = pos.func_177958_n();
        this.targetY = pos.func_177956_o();
        this.targetZ = pos.func_177952_p();
        this.isLost = false;
        this.func_70186_c(this.targetX, this.targetY, this.targetZ, this.func_70185_h(), 0.01f);
    }

    public void func_70071_h_() {
        if (this.isLost) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            double posX = this.func_226277_ct_();
            double posY = this.func_226278_cu_();
            double posZ = this.func_226281_cx_();
            this.field_70142_S = posX;
            this.field_70137_T = posY;
            this.field_70136_U = posZ;
            double motionX = this.func_213322_ci().field_72450_a;
            double motionY = this.func_213322_ci().field_72448_b;
            double motionZ = this.func_213322_ci().field_72449_c;
            this.func_70107_b(posX += motionX, posY += motionY, posZ += motionZ);
            float f = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            double distX = Math.abs(this.targetX - posX);
            double distY = Math.abs(this.targetY - posY);
            double distZ = Math.abs(this.targetZ - posZ);
            float distance = (float)Math.sqrt(distX * distX + distZ * distZ);
            float distLine = (float)Math.sqrt(distX * distX + distZ * distZ + distY * distY);
            float atan = (float)MathHelper.func_181159_b((double)(this.targetZ - posZ), (double)(this.targetX - posX));
            double horizFactor = (double)f + (double)(distance - f) * 0.0025;
            if (distLine < 1.0f) {
                horizFactor *= 0.8;
                this.func_70106_y();
            }
            motionX = Math.cos(atan) * horizFactor;
            motionZ = Math.sin(atan) * horizFactor;
            motionY = 14.0 * distY / (double)distLine * (double)0.015f;
            this.func_213293_j(motionX, motionY, motionZ);
            if (distX < 0.8 && distZ < 0.8) {
                motionX = 0.0;
                motionZ = 0.0;
                if (distY < 0.8) {
                    motionY = 0.0;
                }
            }
            if (posY < this.targetY) {
                if (motionY < 0.0) {
                    motionY *= -1.0;
                }
            } else if (motionY > 0.0) {
                motionY *= -1.0;
            }
            double speedHReduction = 1.0;
            double speedVReduction = 1.0;
            if (this.field_70173_aa < 20) {
                speedHReduction = 2.2;
                speedVReduction = 12.2;
            }
            if (this.field_70173_aa < 40) {
                speedHReduction = 1.8;
                speedVReduction = 10.0;
            } else if (this.field_70173_aa < 100) {
                speedHReduction = 1.2;
                speedVReduction = 6.0;
            } else if (this.field_70173_aa < 150) {
                speedHReduction = 1.1;
                speedVReduction = 2.0;
            } else if (this.field_70173_aa < 500) {
                speedHReduction = 1.0;
                speedVReduction = 1.1;
            }
            motionX /= speedHReduction;
            motionY /= speedVReduction;
            motionZ /= speedHReduction;
            if (this.field_70173_aa > 9999) {
                this.func_70106_y();
            }
            if (motionX == 0.0 && motionY == 0.0 && motionZ == 0.0) {
                this.func_70106_y();
            }
            this.func_213293_j(motionX, motionY, motionZ);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item func_213885_i() {
        return ItemRegistry.spawner_seeker;
    }

    protected void func_70227_a(RayTraceResult result) {
    }
}

