/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard.filter;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.datacard.filter.CapabilityProviderFilterCard;
import com.lothrazar.cyclic.item.datacard.filter.ContainerProviderFilterCard;
import com.lothrazar.cyclic.item.datacard.filter.ScreenFilterCard;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.List;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FilterCardItem
extends ItemBase {
    public static final int SLOT_FLUID = 8;
    private static final String NBTFILTER = "filter";

    public FilterCardItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            boolean isIgnore = FilterCardItem.getIsIgnoreList(stack);
            TranslationTextComponent t = new TranslationTextComponent("cyclic.screen.filter." + isIgnore);
            t.func_240699_a_(isIgnore ? TextFormatting.DARK_GRAY : TextFormatting.DARK_BLUE);
            tooltip.add((ITextComponent)t);
            CompoundNBT stackTag = stack.func_196082_o();
            if (stackTag.func_74764_b("fluidTooltip")) {
                String fluidTooltip = stackTag.func_74779_i("fluidTooltip");
                tooltip.add((ITextComponent)new TranslationTextComponent(fluidTooltip).func_240699_a_(TextFormatting.AQUA));
            }
            if (stackTag.func_74764_b("itemTooltip")) {
                String itemTooltip = stackTag.func_74779_i("itemTooltip");
                tooltip.add((ITextComponent)new TranslationTextComponent(itemTooltip).func_240699_a_(TextFormatting.GRAY));
            }
            if (stackTag.func_74764_b("itemCount")) {
                int itemCount = stackTag.func_74762_e("itemCount");
                t = new TranslationTextComponent("cyclic.screen.filter.item.count");
                t.func_240702_b_("" + itemCount);
                t.func_240699_a_(TextFormatting.GRAY);
                tooltip.add((ITextComponent)t);
            }
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && !playerIn.func_213453_ef()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new ContainerProviderFilterCard(), (BlockPos)playerIn.func_233580_cy_());
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CapabilityProviderFilterCard();
    }

    @Override
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.filter_data, ScreenFilterCard::new);
    }

    public static void toggleFilterType(ItemStack filter) {
        boolean prev = FilterCardItem.getIsIgnoreList(filter);
        filter.func_77978_p().func_74757_a(NBTFILTER, !prev);
    }

    public static FluidStack getFluidStack(ItemStack filterStack) {
        ItemStack bucket;
        IFluidHandler fluidInStack;
        if (!(filterStack.func_77973_b() instanceof FilterCardItem)) {
            return FluidStack.EMPTY;
        }
        IItemHandler myFilter = (IItemHandler)filterStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (myFilter != null && (fluidInStack = (IFluidHandler)(bucket = myFilter.getStackInSlot(8)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null)) != null && fluidInStack.getFluidInTank(0) != null) {
            return fluidInStack.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public static boolean filterAllowsExtract(ItemStack filterStack, ItemStack itemTarget) {
        if (!(filterStack.func_77973_b() instanceof FilterCardItem)) {
            return true;
        }
        boolean isEmpty = false;
        boolean isMatchingList = false;
        boolean isIgnoreList = FilterCardItem.getIsIgnoreList(filterStack);
        IItemHandler myFilter = (IItemHandler)filterStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (myFilter != null) {
            for (int i = 0; i < myFilter.getSlots(); ++i) {
                ItemStack filterPtr = myFilter.getStackInSlot(i);
                if (filterPtr.func_190926_b()) continue;
                isEmpty = false;
                if (!UtilItemStack.matches(itemTarget, filterPtr)) continue;
                isMatchingList = true;
                break;
            }
        }
        if (isIgnoreList) {
            return !isMatchingList;
        }
        return isEmpty || isMatchingList;
    }

    private static boolean getIsIgnoreList(ItemStack filterStack) {
        return filterStack.func_196082_o().func_74767_n(NBTFILTER);
    }

    public static boolean filterAllowsExtract(ItemStack filterStack, FluidStack fluidInTank) {
        if (!(filterStack.func_77973_b() instanceof FilterCardItem)) {
            return true;
        }
        FluidStack fluidFilter = FilterCardItem.getFluidStack(filterStack);
        boolean isMatchingList = fluidFilter.getFluid() == fluidInTank.getFluid();
        boolean isIgnoreList = FilterCardItem.getIsIgnoreList(filterStack);
        if (isIgnoreList) {
            return !isMatchingList;
        }
        return fluidFilter.isEmpty() || isMatchingList;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        IItemHandler cap;
        CompoundNBT nbt = stack.func_196082_o();
        FluidStack fluidStack = FilterCardItem.getFluidStack(stack);
        if (!fluidStack.isEmpty()) {
            nbt.func_74778_a("fluidTooltip", fluidStack.getDisplayName().getString());
        }
        if ((cap = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
            int count = 0;
            ITextComponent first = null;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).func_190926_b()) continue;
                ++count;
                if (first != null) continue;
                first = cap.getStackInSlot(i).func_200301_q();
            }
            nbt.func_74768_a("itemCount", count);
            if (first != null) {
                nbt.func_74778_a("itemTooltip", first.getString());
            }
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbt) {
        if (nbt != null) {
            CompoundNBT stackTag = stack.func_196082_o();
            stackTag.func_74778_a("itemTooltip", nbt.func_74779_i("itemTooltip"));
            stackTag.func_74778_a("fluidTooltip", nbt.func_74779_i("fluidTooltip"));
            stackTag.func_74768_a("itemCount", nbt.func_74762_e("itemCount"));
        }
        super.readShareTag(stack, nbt);
    }
}

