/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.carrot;

import com.lothrazar.cyclic.base.ItemEntityInteractable;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ItemHorseEnder
extends ItemEntityInteractable {
    public static final String NBT_KEYACTIVE = "cyclic_carrot_ender";

    public ItemHorseEnder(Item.Properties prop) {
        super(prop);
    }

    public static void onSuccess(LivingEntity liv) {
        UtilSound.playSound((Entity)liv, SoundEvents.field_187664_bz);
        UtilParticle.spawnParticle(liv.field_70170_p, (IParticleData)ParticleTypes.field_197614_g, liv.func_233580_cy_(), 3);
        ItemHorseEnder.increment(liv, -1);
    }

    private static void increment(LivingEntity ahorse, int val) {
        int old = ahorse.getPersistentData().func_74762_e(NBT_KEYACTIVE);
        ahorse.getPersistentData().func_74768_a(NBT_KEYACTIVE, old + val);
    }

    @Override
    public void interactWith(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().func_77973_b() == this && event.getTarget() instanceof AbstractHorseEntity && !event.getPlayer().func_184811_cZ().func_185141_a((Item)this)) {
            AbstractHorseEntity ahorse = (AbstractHorseEntity)event.getTarget();
            if (event.getTarget() instanceof AbstractChestedHorseEntity && ahorse.func_110248_bS()) {
                AbstractChestedHorseEntity ss = (AbstractChestedHorseEntity)event.getTarget();
                ss.func_110207_m(true);
            }
            ItemHorseEnder.increment((LivingEntity)ahorse, 1);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.getPlayer().func_184811_cZ().func_185145_a((Item)this, 1);
            event.getItemStack().func_190918_g(1);
            int current = ahorse.getPersistentData().func_74762_e(NBT_KEYACTIVE);
            UtilChat.addChatMessage(event.getPlayer(), UtilChat.lang("item.cyclic.carrot_ender.count") + current);
        }
    }
}

