/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.item.bauble.ItemBaseToggle;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.CharmUtil;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CharmBase
extends ItemBaseToggle {
    private static final int YLOWEST = -30;
    private static final int YDEST = 255;
    private static final int FIREPROTSECONDS = 10;
    private static final int FALLDISTANCESECONDS = 5;
    private static final int FALLDISTANCELIMIT = 5;
    public static final UUID ID_SPEED = UUID.fromString("12230aa2-eff2-4a81-b92b-a1cb95f115c6");
    public static final UUID ID_LUCK = UUID.fromString("acc30aa2-eff2-4a81-b92b-a1cb95f115c6");
    public static final UUID ID_ATTACKSPEED = UUID.fromString("b4678aa2-eff2-4a81-b92b-a1cb95f115c6");
    boolean fireProt;
    boolean poisonProt;
    boolean witherProt;
    boolean voidProt;
    boolean wingCharm;
    boolean sailboatCharm;

    public CharmBase(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.canUse(stack)) {
            return;
        }
        if (!this.isOn(stack)) {
            return;
        }
        this.tryVoidTick(stack, worldIn, entityIn);
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        this.tryPoisonTick(stack, entityIn, living);
        this.tryWitherTick(stack, entityIn, living);
        this.tryWingTick(stack, entityIn, living);
        this.tryFireTick(stack, living);
    }

    private void tryWingTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.wingCharm && living.field_70143_R > 5.0f && !living.func_70644_a(Effects.field_204839_B)) {
            EffectInstance eff = new EffectInstance(Effects.field_204839_B, 100, 1);
            living.func_195064_c(eff);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound((Entity)living, SoundEvents.field_187644_cT);
        }
    }

    private void tryFireTick(ItemStack stack, LivingEntity living) {
        if (this.fireProt && living.func_70027_ad() && !living.func_70644_a(Effects.field_76426_n)) {
            EffectInstance eff = new EffectInstance(Effects.field_76426_n, 200, 0);
            eff.field_188421_h = false;
            living.func_195064_c(eff);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound((Entity)living, SoundEvents.field_187646_bt);
            UtilParticle.spawnParticle(living.field_70170_p, (IParticleData)ParticleTypes.field_197618_k, living.func_233580_cy_(), 9);
        }
    }

    private void tryWitherTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.witherProt && living.func_70644_a(Effects.field_82731_v)) {
            living.func_184596_c(Effects.field_82731_v);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound(entityIn, SoundEvents.field_187664_bz);
        }
    }

    private void tryPoisonTick(ItemStack stack, Entity entityIn, LivingEntity living) {
        if (this.poisonProt && living.func_70644_a(Effects.field_76436_u)) {
            living.func_184596_c(Effects.field_76436_u);
            UtilItemStack.damageItem(living, stack);
            UtilSound.playSound(entityIn, SoundEvents.field_187664_bz);
        }
    }

    private void tryVoidTick(ItemStack stack, World worldIn, Entity entityIn) {
        if (this.voidProt && entityIn.func_233580_cy_().func_177956_o() < -30 && entityIn instanceof LivingEntity) {
            UtilEntity.enderTeleportEvent((LivingEntity)entityIn, worldIn, new BlockPos(entityIn.func_233580_cy_().func_177958_n(), 255, entityIn.func_233580_cy_().func_177952_p()));
            if (entityIn instanceof LivingEntity) {
                UtilItemStack.damageItem((LivingEntity)entityIn, stack);
            }
            UtilSound.playSound(entityIn, SoundEvents.field_187534_aX);
        }
    }

    private static void toggleAttribute(PlayerEntity player, Item charm, Attribute attr, UUID id, float factor, int flatIncrease) {
        ItemStack charmStack = CharmUtil.getIfEnabled(player, charm);
        ModifiableAttributeInstance attrPlayer = player.func_110148_a(attr);
        AttributeModifier oldValue = attrPlayer.func_111127_a(id);
        if (charmStack.func_190926_b()) {
            if (oldValue != null) {
                attrPlayer.func_188479_b(id);
            }
        } else {
            if (oldValue == null) {
                double baseSpeed = attrPlayer.func_111125_b();
                AttributeModifier newValue = new AttributeModifier(id, "Bonus from cyclic", baseSpeed * (double)factor + (double)flatIncrease, AttributeModifier.Operation.ADDITION);
                attrPlayer.func_233769_c_(newValue);
                UtilItemStack.damageItem((LivingEntity)player, charmStack);
            }
            UtilItemStack.damageItemRandomly((LivingEntity)player, charmStack);
        }
    }

    public static void charmSpeed(PlayerEntity player) {
        CharmBase.toggleAttribute(player, (Item)ItemRegistry.CHARM_SPEED.get(), Attributes.field_233821_d_, ID_SPEED, ((Double)ConfigRegistry.CHARM_SPEED.get()).floatValue(), 0);
    }

    public static void charmLuck(PlayerEntity player) {
        CharmBase.toggleAttribute(player, (Item)ItemRegistry.CHARM_LUCK.get(), Attributes.field_233828_k_, ID_LUCK, 0.0f, (Integer)ConfigRegistry.CHARM_LUCK.get());
    }

    public static void charmAttackSpeed(PlayerEntity player) {
        CharmBase.toggleAttribute(player, (Item)ItemRegistry.CHARM_ATTACKSPEED.get(), Attributes.field_233825_h_, ID_ATTACKSPEED, ((Double)ConfigRegistry.CHARM_ATTACKSPEED.get()).floatValue(), 0);
    }

    public static void charmExpSpeed(PlayerEntity player) {
        ItemStack charmStack = CharmUtil.getIfEnabled(player, (Item)ItemRegistry.CHARM_XPSPEED.get());
        if (!charmStack.func_190926_b()) {
            player.field_71090_bL = 0;
        }
    }
}

