/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.gui.IHasTooltip;
import com.lothrazar.cyclic.net.PacketTileData;
import com.lothrazar.cyclic.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSliderInteger
extends AbstractSlider
implements IHasTooltip {
    public static final int ARROW_LEFT = 263;
    public static final int ARROW_RIGHT = 262;
    static final int ESC = 256;
    private final double min;
    private final double max;
    private final BlockPos pos;
    private final int field;
    private List<ITextComponent> tooltip;

    public GuiSliderInteger(int x, int y, int width, int height, int field, BlockPos pos, int min, int max, double initialVal) {
        super(x, y, width, height, StringTextComponent.field_240750_d_, 0.0);
        this.field = field;
        this.pos = pos;
        this.min = min;
        this.max = max;
        this.setSliderPercentageOfMax((int)initialVal);
        this.func_230979_b_();
    }

    public double getSliderValue() {
        return this.field_230683_b_;
    }

    public int getField() {
        return this.field;
    }

    @Override
    public List<ITextComponent> getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String tt) {
        this.tooltip = new ArrayList<ITextComponent>();
        this.tooltip.add((ITextComponent)new TranslationTextComponent(tt));
        this.tooltip.add((ITextComponent)new TranslationTextComponent("cyclic.gui.sliderkeys").func_240699_a_(TextFormatting.DARK_GRAY));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            this.moveSliderAndUpdate((int)delta);
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            ClientPlayerEntity pl = Minecraft.func_71410_x().field_71439_g;
            if (pl != null) {
                pl.func_71053_j();
            }
            return true;
        }
        if (keyCode == 263 || keyCode == 262) {
            int delta;
            int n = delta = keyCode == 263 ? -1 : 1;
            if (Screen.func_231173_s_()) {
                delta *= 5;
            } else if (Screen.func_231174_t_()) {
                delta *= 10;
            }
            this.moveSliderAndUpdate(delta);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void moveSliderAndUpdate(int delta) {
        this.setSliderPercentageOfMax(this.getSliderAsInteger() + delta);
        this.func_230972_a_();
        this.func_230979_b_();
    }

    protected void func_230979_b_() {
        int val = this.getSliderAsInteger();
        this.func_238482_a_((ITextComponent)new TranslationTextComponent("" + val));
    }

    protected void func_230972_a_() {
        int val = this.getSliderAsInteger();
        PacketRegistry.INSTANCE.sendToServer((Object)new PacketTileData(this.field, val, this.pos));
    }

    private void setSliderPercentageOfMax(int val) {
        this.field_230683_b_ = (double)val / this.max;
    }

    public int getSliderAsInteger() {
        return MathHelper.func_76128_c((double)MathHelper.func_151238_b((double)this.min, (double)this.max, (double)this.getSliderValue()));
    }
}

