/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.data.CyclicFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDataEvents {
    public static Map<UUID, CyclicFile> DATA_QUEUE = new HashMap<UUID, CyclicFile>();
    public static final String FILE_EXT = ".dat";

    public static CyclicFile getOrCreate(PlayerEntity player) {
        UUID id = player.func_110124_au();
        if (!DATA_QUEUE.containsKey(id)) {
            DATA_QUEUE.put(id, new CyclicFile(player.func_110124_au()));
        }
        return DATA_QUEUE.get(id);
    }

    @SubscribeEvent
    public void onSaveFile(PlayerEvent.SaveToFile event) {
        PlayerEntity player = event.getPlayer();
        if (DATA_QUEUE.containsKey(player.func_110124_au())) {
            CyclicFile dataToSave = DATA_QUEUE.get(player.func_110124_au());
            CompoundNBT data = dataToSave.write();
            try {
                File mctomb = new File(event.getPlayerDirectory(), this.getPlayerFile(player));
                FileOutputStream fileoutputstream = new FileOutputStream(mctomb);
                CompressedStreamTools.func_74799_a((CompoundNBT)data, (OutputStream)fileoutputstream);
                fileoutputstream.close();
                ModCyclic.LOGGER.info("Cyclic PlayerEvent.SaveToFile success" + data);
            }
            catch (IOException e) {
                ModCyclic.LOGGER.error("IO cyclic file error", e);
            }
        }
    }

    private String getPlayerFile(PlayerEntity player) {
        return player.func_110124_au() + "_cyclic" + FILE_EXT;
    }

    @SubscribeEvent
    public void onLoadFile(PlayerEvent.LoadFromFile event) {
        PlayerEntity player = event.getPlayer();
        File mctomb = new File(event.getPlayerDirectory(), this.getPlayerFile(player));
        if (mctomb.exists()) {
            try {
                FileInputStream fileinputstream = new FileInputStream(mctomb);
                CompoundNBT data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                fileinputstream.close();
                CyclicFile dataLoaded = new CyclicFile(player.func_110124_au());
                dataLoaded.read(data);
                DATA_QUEUE.put(player.func_110124_au(), dataLoaded);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("IO error", e);
            }
        }
    }
}

