/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilPlayer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantReach
extends EnchantBase {
    private static final String NBT_REACH_ON = "reachon";
    public static final int REACH_BOOST = 11;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "reach";

    public EnchantReach(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 1;
    }

    private void turnReachOff(PlayerEntity player) {
        player.getPersistentData().func_74757_a(NBT_REACH_ON, false);
        UtilPlayer.removePlayerReach(player);
    }

    private void turnReachOn(PlayerEntity player) {
        player.getPersistentData().func_74757_a(NBT_REACH_ON, true);
        UtilPlayer.addPlayerReach(player, 11);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        ItemStack armor = player.func_184582_a(EquipmentSlotType.CHEST);
        int level = 0;
        if (!armor.func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)armor) != null && EnchantmentHelper.func_82781_a((ItemStack)armor).containsKey((Object)this)) {
            level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)armor).get((Object)this);
        }
        if (level > 0) {
            this.turnReachOn(player);
        } else if (player.getPersistentData().func_74764_b(NBT_REACH_ON) && player.getPersistentData().func_74767_n(NBT_REACH_ON)) {
            this.turnReachOff(player);
        }
    }
}

