/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.GrowthUtil;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantGrowth
extends EnchantBase {
    public static final int HEIGHT = 2;
    public static final double ODDS = 0.04;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "growth";
    public static ForgeConfigSpec.IntValue RADIUSFACTOR;

    public EnchantGrowth(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity p;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && ((p = (PlayerEntity)entity).func_175149_v() || !p.func_70089_S())) {
            return;
        }
        int level = this.getCurrentLevelTool(entity.func_184586_b(Hand.MAIN_HAND));
        if (level > 0 && !entity.field_70170_p.field_72995_K) {
            if (entity.field_70170_p.field_73012_v.nextDouble() > 0.04 * (double)level) {
                return;
            }
            int growthLimit = level * 2 + (entity.field_70170_p.func_72896_J() ? 4 : 1);
            int grown = 0;
            List<BlockPos> shape = UtilShape.squareHorizontalFull(entity.func_233580_cy_().func_177977_b(), level * (Integer)RADIUSFACTOR.get());
            shape = UtilShape.repeatShapeByHeight(shape, 2);
            Collections.shuffle(shape);
            for (int i = 0; i < shape.size() && grown < growthLimit; ++i) {
                GrowthUtil.tryGrow(entity.field_70170_p, shape.get(i), 0.4);
            }
            if (grown > 0) {
                UtilItemStack.damageItem(entity, entity.func_184586_b(Hand.MAIN_HAND));
            }
        }
    }
}

